% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdi.r
\name{gdi}
\alias{gdi}
\title{Estimate volume using Graphic Double Integration.}
\usage{
gdi(
  lat,
  dors,
  indices = NULL,
  scale = 10,
  sliceL = 1,
  method = "raw",
  k = 2,
  corr = 1,
  smooth.ends = FALSE,
  return = "total"
)
}
\arguments{
\item{lat}{Measurements of diameter in lateral view/first of two orthogonal views to be used with the gdi. Can be either a numeric vector, a data.frame (output of measuresil(...,return="all") with a collumn named "diameter", or a text file with diameter measurements to be scanned.}

\item{dors}{Measurements of diameter in dorsal view/second of two orthogonal views to be used with the gdi. Can be either a numeric vector, a data.frame (output of measuresil(...,return="all") with a collumn named "diameter", or a text file with diameter measurements to be scanned. Must be the same length as lat.}

\item{indices}{Optional indices specifying a subset of the silhouette measurement vectors to be analyzed. Useful if separate segment calculations are desired.}

\item{scale}{Scale of the data, given in terms of how many units of the input data (e.g. pixels) are in one side of the desired unit of output volume. Defaults to 10.}

\item{sliceL}{Length of individual segments to be used in the GDI. Defaults to 1.}

\item{method}{Method to be used for the GDI. Default "raw" setting calculates each segment as an elliptical cylinder with volume = Area * SliceL. Any other string will result in volume being calculated as an elliptical frustum with base areas based on the measurements of segments i and i+1.}

\item{k}{Superellipse exponent to be used for the cross-sectional area. Defaults to 2.0 (normal ellipse).}

\item{corr}{Correction factor for area of cross-sections, calculated as the ratio between the actual cross-sectional area and that of a (super)ellipse (depending on the specified exponent k) with the same diameters. This setting enables the function to account for complex, non-elliptical cross-sections. Default value is 1, i.e. no correction. Can be either a single number, or a numeric vector of the same length as lat and dors (in the case of a changing cross-sectional geometry along the length of the body).}

\item{smooth.ends}{If method != "raw", specify whether first and last segments should be left raw, or taper to 0 (i.e. be approximated as cones). Only applies if there are no leading or following zeros in the measurement vectors.}

\item{return}{Determines whether to report the estimated total volume (if default/"total"), or a data.frame() with segment radii, areas and volumes (if left empty of any other character string).}
}
\value{
Either a single number representing the total volume estimated (with names indicating the horizontal length of the silhouette in the unit determined by scale), or (if return!="total") a data.frame() containing columns with the radii in both dimensions, the estimated elliptical or superelliptical areas, and the segment volumes.
}
\description{
Estimate volume using Graphic Double Integration.
}
\examples{
lateral <- rep(2,4) #generate example data
dorsal <- rep(2,4)
gdi(lat=lateral, dors=dorsal, scale=10, method="raw", k=2.0)
gdi(lat=lateral, dors=lateral/2, scale=10, method="smooth", k=2.3)
}
