% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gratia_derivatives.R
\name{derivatives.galamm}
\alias{derivatives.galamm}
\alias{derivatives}
\title{Derivatives of estimated smooth via finite differences}
\usage{
\method{derivatives}{galamm}(object, ...)
}
\arguments{
\item{object}{An object of class \code{galamm} returned from
\code{\link{galamm}}.}

\item{...}{Other arguments passed on to \code{\link[gratia:derivatives]{gratia::derivatives()}}.}
}
\value{
A tibble.
}
\description{
This function uses \code{gratia::derivatives} to compute derivatives of
estimated smooth via finite differences. See
\code{\link[gratia:derivatives]{gratia::derivatives()}} for details. When \code{object} is not of class
\code{galamm}, it is forwarded to \code{gratia::derivatives()}.
}
\examples{
dat <- subset(cognition, domain == 1 & item == "11")
dat$y <- dat$y[, 1]
mod <- galamm(y ~ s(x) + (1 | id), data = dat)

dd <- derivatives(mod)
draw(dd)

}
\seealso{
Other details of model fit: 
\code{\link{VarCorr}()},
\code{\link{appraise.galamm}()},
\code{\link{coef.galamm}()},
\code{\link{confint.galamm}()},
\code{\link{deviance.galamm}()},
\code{\link{factor_loadings.galamm}()},
\code{\link{family.galamm}()},
\code{\link{fitted.galamm}()},
\code{\link{fixef}()},
\code{\link{formula.galamm}()},
\code{\link{llikAIC}()},
\code{\link{logLik.galamm}()},
\code{\link{model.frame.galamm}()},
\code{\link{nobs.galamm}()},
\code{\link{predict.galamm}()},
\code{\link{print.VarCorr.galamm}()},
\code{\link{ranef.galamm}()},
\code{\link{residuals.galamm}()},
\code{\link{response}()},
\code{\link{sigma.galamm}()},
\code{\link{vcov.galamm}()}
}
\concept{details of model fit}
