#' @title Extract model fitted values
#'
#' @srrstats {G1.4} Function documented with roxygen2.
#' @srrstats {G2.1a} Expected data types provided for all inputs.
#' @srrstats {RE4.9} Modelled values of response variables.
#'
#' @description
#' Extracts fitted values from a model including random effects.
#'
#' @param object An object of class \code{galamm} returned from
#'   \code{\link{galamm}}.
#' @param ... Optional arguments passed on to other methods. Currently not used.
#'
#'
#' @return A numerical vector with fit values for each row in the input data.
#' @export
#'
#' @family details of model fit
#'
#' @examples
#' # Linear mixed model with heteroscedastic residuals
#' mod <- galamm(
#'   formula = y ~ x + (1 | id),
#'   dispformula = ~ (1 | item),
#'   data = hsced
#' )
#'
#' # Extract fitted values and plot against x
#' plot(hsced$x, fitted(mod))
#'
fitted.galamm <- function(object, ...) {
  object$model$fit
}
