% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmfcc.R
\name{RoMFCC_PhaseII_casewise}
\alias{RoMFCC_PhaseII_casewise}
\title{Robust Multivariate Functional Control Charts - Phase II (casewise version)}
\usage{
RoMFCC_PhaseII_casewise(mfdobj_all_imp, mod_phaseI_casewise)
}
\arguments{
\item{mfdobj_all_imp}{A multivariate functional data object of class \code{mfd}, containing the
concatenation of the fully imputed training and tuning sets to be
monitored for casewise outliers.}

\item{mod_phaseI_casewise}{Output obtained by applying the function \code{RoMFCC_PhaseI_casewise}
to perform Phase I. See \code{\link{RoMFCC_PhaseI_casewise}}}
}
\value{
A \code{data.frame} with as many rows as the number of
multivariate functional observations in the phase II data set and
the following columns:
\itemize{
\item one \code{id} column identifying the multivariate functional observation
in the phase II data set,
\item one \code{T2} column containing the Hotelling T2 statistic
calculated for all observations,
\item one column per each functional variable,
containing its contribution to the T2 statistic,
\item one \code{SPE} column containing the SPE statistic calculated
for all observations,
\item \code{T2_lim} gives the upper control limit of
the Hotelling's T2 control chart,
\item \code{SPE_lim} gives the upper control limit of the SPE control chart
}
}
\description{
It performs Phase II of the Robust Multivariate Functional Control Chart
(RoMFCC) for casewise outlier detection, computing Hotelling's T2 and SPE
monitoring statistics according to the methodology proposed by
Capezza et al. (2024).
}
\examples{
\dontrun{
library(funcharts)
set.seed(0)
dat <- simulate_data_RoMFCC(p_cellwise = 0.05,
                            p_casewise = 0.05,
                            outlier = "outlier_E",
                            M_outlier_cell = 0.03,
                            M_outlier_case = 0.01,
                            max_n_cellwise = 10)
mfdobj <- get_mfd_list(dat$X_mat_list, n_basis = 5)
mfdobj_training <- mfdobj[1:333, ]
mfdobj_tuning <- mfdobj[334:1000, ]
ff_training <- functional_filter(mfdobj = mfdobj_training)
ff_tuning <- functional_filter(mfdobj = mfdobj_tuning)
x_imp_training <- RoMFDI(mfdobj = ff_training$mfdobj)
x_imp_tuning <- RoMFDI(mfdobj = ff_tuning$mfdobj)
X_imp_training <- x_imp_training[[1]]
X_imp_tuning <- x_imp_tuning[[1]]
out_phase1_casewise <- RoMFCC_PhaseI_casewise(
  mfdobj_imp = X_imp_training,
  mfdobj_imp_tuning,X_imp_tuning
)
mfd_all_imputed <- rbind_mfd(X_imp_training, X_imp_tuning)
out_phase2_casewise <- RoMFCC_PhaseII_casewise(
  mfdobj_all_imp = mfdobj_all_imputed,
  mod_phaseI_casewise = out_phase1_casewise
)
plot_control_charts(out_phase2_casewise)
}

}
\references{
Capezza, C., Centofanti, F., Lepore, A., Palumbo, B. (2024)
Robust Multivariate Functional Control Chart.
\emph{Technometrics}, 66(4):531--547, \url{doi:10.1080/00401706.2024.2327346}.
}
