% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_arrange.R
\name{f_arrange}
\alias{f_arrange}
\title{A \code{collapse} version of \code{dplyr::arrange()}}
\usage{
f_arrange(
  .data,
  ...,
  .by = NULL,
  .by_group = FALSE,
  .cols = NULL,
  .descending = FALSE,
  .in_place = FALSE
)
}
\arguments{
\item{.data}{A data frame.}

\item{...}{Variables to arrange by.}

\item{.by}{(Optional). A selection of columns to group by for this operation.
Columns are specified using \code{tidyselect}.}

\item{.by_group}{If \code{TRUE} the sorting will be first done by the group
variables.}

\item{.cols}{(Optional) alternative to \code{...} that accepts
a named character vector or numeric vector.
If speed is an expensive resource, it is recommended to use this.}

\item{.descending}{\verb{[logical(1)]} data frame be arranged in descending order? Default is
\code{FALSE}. In simple cases this can be easily achieved through \code{desc()} but
for a mixture of ascending and descending variables, it's easier to use
the \code{.descending} arg to reverse the order.}

\item{.in_place}{Should data be sorted in-place?
This can be very efficient for large data frames and can be safely used
when overwriting a freshly allocated data frame.
If you're unsure whether the data frame is a freshly allocated object,
use \code{cheapr::semi_copy()} before sorting.

Please note that no new vectors and no copies are created,
data is directly sorted in-memory.
This only works on data frames consisting of atomic vectors.}
}
\value{
A sorted \code{data.frame}.
}
\description{
This is a fast and near-identical alternative to \code{dplyr::arrange()}
using the \code{collapse} package.

\code{desc()} is like \code{dplyr::desc()} but works faster when
called directly on vectors. \cr
}
