#' @name madChelsa
#'
#' @title Rasters of bioclimatic variables for an eastern portion of Madagascar
#'
#' @description Rasters of bioclimatic variables for an eastern portion of Madagascar from CHELSA version 2.1 in unprojected (WGS84) coordinates. Values represent averages across 1980-2010. Only these BIOCLIM variables are included:
#' 	* `bio1`: Mean annual temperature (deg C)
#' 	* `bio7`: Temperature annual range (hottest - coldest month temperature; deg C)
#' 	* `bio12`: Total annual precipitation (mm)
#' 	* `bio15`: Precipitation seasonality (unit-less)
#'
#' @docType data
#'
#' @format An object of class `SpatRaster` in unprojected (WGS84) coordinates.
#'
#' @keywords climate Madagascar
#'
#' @references Karger, D.N., Conrad, O., Bohner, J., Kawohl, T., Kreft, H., Soria-Auza, R.W., Zimmermann, N.E., Linder, H.P., and Kessler, M.  2017.  Climatologies at high resolution for the earth's land surface areas. *Scientific Data* 4:170122. \doi{10.1038/sdata.2017.122}
#'
#' @source \doi{https://doi.org/10.1038/sdata.2017.122}
#'
#' @example man/examples/ex_fastData.r
#'
NULL
