% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-database.R
\name{eyeris_db_split_for_sharing}
\alias{eyeris_db_split_for_sharing}
\title{Split eyerisdb for data sharing and distribution}
\usage{
eyeris_db_split_for_sharing(
  bids_dir,
  db_path = "my-project",
  output_dir = NULL,
  chunk_strategy = "by_data_type",
  n_chunks = 4,
  max_chunk_size_mb = 100,
  data_types = NULL,
  group_by_epoch_label = TRUE,
  include_metadata = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{bids_dir}{Path to the BIDS directory containing the source database}

\item{db_path}{Source database name (defaults to "my-project", becomes "my-project.eyerisdb")}

\item{output_dir}{Directory to save chunked databases (defaults to bids_dir/derivatives/chunked_db)}

\item{chunk_strategy}{Strategy for chunking: "by_data_type", "by_count", or "by_size" (default: "by_data_type")}

\item{n_chunks}{Number of chunks to create when chunk_strategy = "by_count" (default: 4)}

\item{max_chunk_size_mb}{Maximum size per chunk in MB when chunk_strategy = "by_size" (default: 100)}

\item{data_types}{Vector of data types to include. If NULL (default), includes all available}

\item{group_by_epoch_label}{If TRUE (default), processes epoch-related data types separately by epoch label}

\item{include_metadata}{Whether to include eyeris metadata columns in chunked databases (default: TRUE)}

\item{verbose}{Whether to print progress messages (default: TRUE)}
}
\value{
List containing information about created chunked databases and reconstruction instructions
}
\description{
Creates multiple smaller eyerisdb files from a single large database for easier
distribution via platforms with file size limits (GitHub, OSF, data repositories, etc.).
Data can be chunked by data type, by number of chunks, or by maximum file size.
Includes metadata to facilitate reconstruction of the original database.
}
\examples{
\dontrun{
# These examples require an existing eyeris database

# Chunk by data type (each data type gets its own database file)
chunk_info <- eyeris_db_split_for_sharing(
  bids_dir = "/path/to/bids",
  db_path = "large-project",
  chunk_strategy = "by_data_type"
)

# Chunk into 6 files by count
chunk_info <- eyeris_db_split_for_sharing(
  bids_dir = "/path/to/bids",
  db_path = "large-project",
  chunk_strategy = "by_count",
  n_chunks = 6
)

# Chunk by size (max 50MB per file)
chunk_info <- eyeris_db_split_for_sharing(
  bids_dir = "/path/to/bids",
  db_path = "large-project",
  chunk_strategy = "by_size",
  max_chunk_size_mb = 50
)
}

}
