\name{Distance correlation matrix}
\alias{dcorm}
\title{
Distance correlation matrix
}

\description{
Distance correlation matrix.
}

\usage{
dcorm(x, bc = FALSE)
}

\arguments{
\item{x}{
A numerical matrix.
}
\item{bc}{
If you want the bias-corrected distance correlation set this equal to TRUE.
}
}

\details{
The squared distance correlation matrix is computed.
}

\value{
A matrix with the pairwise squared distance correlations between all variables in x.
}

\references{
G.J. Szekely, M.L. Rizzo and N. K. Bakirov (2007). Measuring and Testing Independence
by Correlation of Distances. Annals of Statistics, 35(6):2769-2794.
}

\author{
Michail Tsagris.

R implementation and documentation: Michail Tsagris \email{mtsagris@uoc.gr}.
}

\seealso{
\code{ \link{dcor}
}
}

\examples{
x <- as.matrix( iris[1:50, 1:4] )
res <- dcorm(x)
}
