% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unadmit_untested.R
\name{unadmit_untested}
\alias{unadmit_untested}
\title{Make untested and unrecommended doses inadmissible.}
\usage{
unadmit_untested(parent_selector_factory)
}
\arguments{
\item{parent_selector_factory}{Object of type \code{\link{selector_factory}}.}
}
\value{
an object of type \code{\link{selector_factory}} that can fit a
dose-finding model to outcomes.
}
\description{
This method sets untested and unrecommended doses to inadmissible,
irrespective the view of the parent selector.
}
\examples{
skeleton <- c(0.05, 0.1, 0.25, 0.4, 0.6)
target <- 0.25
model1 <- get_dfcrm(skeleton = skeleton, target = target) \%>\%
  dont_skip_doses() \%>\%
  unadmit_untested()
fit1 <- model1 \%>\% fit('1NNN')

# Dose 1 has been tested. Dose 2 is recommended. All other doses are not
# admissible:
fit1 \%>\% dose_admissible()
}
