% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stick_on_num_tox.R
\name{stick_on_num_tox}
\alias{stick_on_num_tox}
\title{Stay at the current dose when num_tox of num_patients have experienced tox}
\usage{
stick_on_num_tox(parent_selector_factory, num_tox, num_patients)
}
\arguments{
\item{parent_selector_factory}{Object of type \code{\link{selector_factory}}.}

\item{num_tox}{Stick at current dose when this many toxicities are seen...}

\item{num_patients}{...in this many patients}
}
\value{
an object of type \code{\link{selector_factory}} that can fit a
dose-finding model to outcomes.
}
\description{
This method continues at the current dose when the outcomes observed exactly
num_doses toxicity events in num_patients patients.
}
\examples{
target <- 0.25
# Where a design might choose to deescalate:
model1 <- get_mtpi2(num_doses = 5, target = target, epsilon1 = 0.05,
                    epsilon2 = 0.05, exclusion_certainty = 0.95)
model1 \%>\% fit('1NNN 2NTN') \%>\% recommended_dose()
# you can alter that behaviour when a precise number of toxicities have been
# seen in a precise number of patients:
model2 <- get_mtpi2(num_doses = 5, target = target, epsilon1 = 0.05,
                    epsilon2 = 0.05, exclusion_certainty = 0.95) \%>\%
            stick_on_num_tox(num_tox = 1, num_patients = 3)
model2 \%>\% fit('1NNN 2NTN') \%>\% recommended_dose()
# The current dose is recommended instead.
}
