% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alpha.R
\name{alpha}
\alias{alpha}
\title{Cronbach's Coefficient Alpha}
\usage{
alpha(x)
}
\arguments{
\item{x}{A data frame or matrix containing item responses, with rows as
respondents (subjects) and columns as items.}
}
\value{
A named list with the following elements:
\describe{
\item{alpha}{Cronbach's coefficient alpha.}
\item{sem}{Standard error of measurement (SEM) based on alpha.}
}
}
\description{
Compute Cronbach's coefficient alpha and the associated standard error of
measurement (SEM) for a set of items.
}
\details{
Cronbach's alpha is an estimate of the internal consistency reliability of a
test. This implementation:
\itemize{
\item removes rows with any missing values using \code{stats::na.exclude()},
\item computes the sample covariance matrix of the items,
\item uses the classical formula
\deqn{\alpha = \frac{k}{k-1} \left(1 - \frac{\sum \sigma_i^2}{\sigma_X^2}\right),}
where \eqn{k} is the number of items, \eqn{\sigma_i^2} are item variances,
and \eqn{\sigma_X^2} is the variance of the total score,
\item computes SEM as \eqn{\text{SD}(X) \sqrt{1 - \alpha}}.
}
}
\examples{
data(data.u)
alpha(data.u)

}
