% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/provider-portkey.R
\name{chat_portkey}
\alias{chat_portkey}
\alias{models_portkey}
\title{Chat with a model hosted on PortkeyAI}
\usage{
chat_portkey(
  model,
  system_prompt = NULL,
  base_url = "https://api.portkey.ai/v1",
  api_key = NULL,
  credentials = NULL,
  virtual_key = deprecated(),
  params = NULL,
  api_args = list(),
  echo = NULL,
  api_headers = character()
)

models_portkey(base_url = "https://api.portkey.ai/v1", api_key = portkey_key())
}
\arguments{
\item{model}{The model name, e.g. \verb{@my-provider/my-model}.}

\item{system_prompt}{A system prompt to set the behavior of the assistant.}

\item{base_url}{The base URL to the endpoint; the default is OpenAI's
public API.}

\item{api_key}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Use \code{credentials} instead.}

\item{credentials}{Override the default credentials. You generally should not need this argument; instead set the \code{PORTKEY_API_KEY} environment variable. The best place to set this is in \code{.Renviron},
which you can easily edit by calling \code{usethis::edit_r_environ()}.

If you do need additional control, this argument takes a zero-argument function that returns either a string (the API key), or a named list (added as additional headers to every request).}

\item{virtual_key}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}.
Portkey now recommend supplying the model provider
(formerly known as the \code{virtual_key}), in the model name, e.g.
\verb{@my-provider/my-model}. See
\url{https://portkey.ai/docs/support/upgrade-to-model-catalog} for details.

For backward compatibility, the \code{PORTKEY_VIRTUAL_KEY} env var is still used
if the model doesn't include a provider.}

\item{params}{Common model parameters, usually created by \code{\link[=params]{params()}}.}

\item{api_args}{Named list of arbitrary extra arguments appended to the body
of every chat API call. Combined with the body object generated by ellmer
with \code{\link[=modifyList]{modifyList()}}.}

\item{echo}{One of the following options:
\itemize{
\item \code{none}: don't emit any output (default when running in a function).
\item \code{output}: echo text and tool-calling output as it streams in (default
when running at the console).
\item \code{all}: echo all input and output.
}

Note this only affects the \code{chat()} method.}

\item{api_headers}{Named character vector of arbitrary extra headers appended
to every chat API call.}
}
\value{
A \link{Chat} object.
}
\description{
\href{https://portkey.ai/docs/product/ai-gateway/universal-api}{PortkeyAI}
provides an interface (AI Gateway) to connect through its Universal API to a
variety of LLMs providers via a single endpoint.
}
\examples{
\dontrun{
chat <- chat_portkey()
chat$chat("Tell me three jokes about statisticians")
}
}
\seealso{
Other chatbots: 
\code{\link{chat_anthropic}()},
\code{\link{chat_aws_bedrock}()},
\code{\link{chat_azure_openai}()},
\code{\link{chat_cloudflare}()},
\code{\link{chat_databricks}()},
\code{\link{chat_deepseek}()},
\code{\link{chat_github}()},
\code{\link{chat_google_gemini}()},
\code{\link{chat_groq}()},
\code{\link{chat_huggingface}()},
\code{\link{chat_mistral}()},
\code{\link{chat_ollama}()},
\code{\link{chat_openai}()},
\code{\link{chat_openai_compatible}()},
\code{\link{chat_openrouter}()},
\code{\link{chat_perplexity}()}
}
\concept{chatbots}
