% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean-vahydro.R
\name{clean_vahydro}
\alias{clean_vahydro}
\title{Clean dataset of ecological and hydrologic data}
\usage{
clean_vahydro(watershed.df)
}
\arguments{
\item{watershed.df}{A dataframe of sites with ecological and hydrologic data}
}
\value{
A cleaned dataframe of sites with ecological and hydrologic data
}
\description{
Given a dataframe of flow metric and richness metric data
(Typically retrieved from the DEQ VAHydro database), removes all sites where the
ratio of Drainage Area:Mean Annual Flow is greater than 1000, also aggregates to the
maximum richness value at each x-metric value
}
\examples{
\donttest{
# We don't run this example by R CMD check, because it takes >10s

# Retrieve dataset of interest
watershed.df <- data.frame(
    MAF = c(100, 200, 300, 400, 526, 600, 700, 800, 400, 900, 1000, 100, 100),
    NT.TOTAL.UNIQUE = c(10, 20, 30, 40, 50, 40, 30 , 20, 50, 10, 10,99999,87),
    watershed.code = "test_testcode",
    hydrocode = c("t1","t2","t3","t4","t5","t6","t7","t8","t9","t10","t11","t12","t13"),
    DA_SQMI = c(110, 220000, 280, 360, 530, 604, 712, 698, 40000, 905, 1087, 98, 87),
    x.metric = c(100, 200, 300, 400, 526, 600, 700, 800, 400, 900, 1000, 100, 100)
    )
# Clean the dataset
clean_vahydro(watershed.df)
}
}
