% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamicVariation.R
\name{dynamicVariation}
\alias{dynamicVariation}
\alias{variationDecomposition}
\title{Dynamic variation and variation decomposition}
\usage{
dynamicVariation(x, ...)

variationDecomposition(x)
}
\arguments{
\item{x}{An object of class \code{trajectories} (or its children subclasses \code{fd.trajectories} or \code{cycles}).}

\item{...}{Additional params to be passed to function \code{\link{trajectoryDistances}}.}
}
\value{
\itemize{
\item{Function \code{dynamicVariance} returns a list with three elements (dynamic sum of squares, dynamic variance and a vector of trajectory relative contributions)}
\item{Function \code{variationDecomposition} returns a data frame with results (sum of squares, degrees of freedom and variance estimates) for each variance component and the total.}
}
}
\description{
\itemize{
\item{Function \code{dynamicVariation} assesses the amount of dynamic variation observed across trajectories and the relative contribution of each of them.}
\item{Function \code{variationDecomposition} performs a sum of squares decomposition of total variation in three components: (1) across trajectories (entities); (2) across time points;
(3) their interaction.}
}
}
\details{
Function \code{variationDecomposition} requires trajectories to be synchronous. The SS sum of \code{temporal} and \code{interaction} components correspond to the SS sum, across trajectories, of
function \code{\link{trajectoryInternalVariation}}.
}
\examples{
#Description of entities and surveys
entities <- c("1","1","1","1","2","2","2","2","3","3","3","3")
surveys <- c(1,2,3,4,1,2,3,4,1,2,3,4)
  
#Raw data table
xy<-matrix(0, nrow=12, ncol=2)
xy[2,2]<-1
xy[3,2]<-2
xy[4,2]<-3
xy[5:6,2] <- xy[1:2,2]
xy[7,2]<-1.5
xy[8,2]<-2.0
xy[5:6,1] <- 0.25
xy[7,1]<-0.5
xy[8,1]<-1.0
xy[9:10,1] <- xy[5:6,1]+0.25
xy[11,1] <- 1.0
xy[12,1] <-1.5
xy[9:10,2] <- xy[5:6,2]
xy[11:12,2]<-c(1.25,1.0)

d <- dist(xy)

# Defines trajectories
x <- defineTrajectories(d, entities, surveys)

# Assessment of dynamic variation and individual trajectory contributions
dynamicVariation(x)

# Variation decomposition (entity, temporal and interaction) for synchronous 
# trajectories:
variationDecomposition(x)

# check the correspondence with internal variation
sum(variationDecomposition(x)[c("time", "interaction"),"ss"])
sum(trajectoryInternalVariation(x)$internal_ss)

}
\seealso{
\code{\link{defineTrajectories}}, \code{\link{is.synchronous}}, \code{\link{trajectoryDistances}}, \code{\link{trajectoryInternalVariation}}
}
