% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_lm2.R
\name{calc_lm2}
\alias{calc_lm2}
\title{Linear regression analysis of easynem-class (two-factor)}
\usage{
calc_lm2(data, group1, group2, x, y, ...)
}
\arguments{
\item{data}{An \code{\link{easynem-class}} object.}

\item{group1}{The group variable factor 1.}

\item{group2}{The group variable factor 2.}

\item{x}{X-axis.}

\item{y}{Y-axis.}

\item{...}{Other parameters of the \code{\link[stats]{lm}} function.}
}
\value{
Returns an \code{\link{lme2-class}} object storing the results of a
linear regression analysis.
}
\description{
The \code{calc_lm2()} function is used for linear regression analysis of
\code{\link{easynem-class}}. Note: Both the horizontal and vertical coordinates of this
function must be continuous variables.
}
\details{
To facilitate code interpretation, it is recommended to use the pipe symbol
\code{\link{|>}} to connect functions:

\if{html}{\out{<div class="sourceCode">}}\preformatted{nem_lm <- nem |> calc_lm2(con_crop, season, x = SOC, y = pH)
}\if{html}{\out{</div>}}
}
\examples{
nem <- read_nem(tab = easynem_example("nemtab1.csv"),
                tax = easynem_example("nemtax1.csv"),
                meta = easynem_example("nemmeta1.csv"))
nem_lm <- nem |> calc_lm2(con_crop, season, x = pH, y = Fe)
}
\seealso{
Other functions in this R package for data calculations:
\code{\link{calc_beta2}}, \code{\link{calc_compare}}, \code{\link{calc_compare2}},
\code{\link{calc_beta}}, \code{\link{calc_alpha}}, \code{\link{calc_nemindex}},
\code{\link{calc_funguild}}, \code{\link{calc_funguild2}}, \code{\link{calc_mf2}},
\code{\link{calc_mf}}, \code{\link{calc_ter2}}, \code{\link{calc_ef}},
\code{\link{calc_ef2}}, \code{\link{calc_lm}}.
}
