% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation_models.R
\name{run_trial_lca_gi}
\alias{run_trial_lca_gi}
\title{Run a single trial of the LCA-GI simulation}
\usage{
run_trial_lca_gi(
  trial_setting,
  item_formulas,
  n_items,
  max_reached,
  max_t,
  dt,
  noise_factory,
  trajectories = FALSE
)
}
\arguments{
\item{trial_setting}{A list of named values representing the trial settings}

\item{item_formulas}{A list of formulas defining the item parameters}

\item{n_items}{The number of items to simulate}

\item{max_reached}{The threshold for evidence accumulation}

\item{max_t}{The maximum time to simulate}

\item{dt}{The step size for each increment}

\item{noise_factory}{A function that takes trial_setting and returns a noise
function with signature function(n, dt)}

\item{trajectories}{Whether to return full output including trajectories.}
}
\value{
A list containing the simulation results
}
\description{
This function runs a single trial of the LCA-GI (Leaky Competing Accumulator
with Global Inhibition) simulation using the provided item formulas and trial
settings. It's a wrapper around the core C++ function for LCA-GI.
}
\note{
After evaluation, parameters A, V, ndt, beta, and k are expected
to be numeric vectors of length n_items. And they are matched by position.
So, the first element of A, V, ndt, beta, and k corresponds to the first
item, and so on.
}
\keyword{internal}
