% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outputConstraintTab.R
\name{outputConstraintTab}
\alias{outputConstraintTab}
\title{Evaluate Invariance Equality Constraints in a specified Dyadic Invariance Model}
\usage{
outputConstraintTab(
  constrainFit,
  filterSig = FALSE,
  gtTab = FALSE,
  writeTo = NULL,
  fileName = NULL
)
}
\arguments{
\item{constrainFit}{A fitted \code{lavaan} model with dyadic invariance equality constraints}

\item{filterSig}{A logical indicating whether to filter for significant constraints (default is \code{FALSE})}

\item{gtTab}{A logical input indicating whether to generate the output in \code{gt::gt()} table object format (\code{TRUE}).
By default (\code{FALSE}), the output is generated in \code{tibble::tibble()} format.
Users can also apply the \code{writeTo} argument if they wish to export the \code{gt:gt()} table object.}

\item{writeTo}{A character string specifying a directory path to where the \code{gt::gt()} table object should be saved.
If set to ".", the file will be written to the current working directory.
The default is \code{NULL}, and examples use a temporary directory created by \code{tempdir()}.
\code{writeTo} is only relevant if \code{gtTab = TRUE}.}

\item{fileName}{A character string specifying a desired base name for the output \code{gt::gt()} file.
If a \code{fileName} is not provided (i.e., \code{fileName = NULL}), then a default will be used (i.e., "dySEM_table").
The resulting base name will automatically be appended with a \code{.rtf} file extension.
\code{fileName} is only relevant if \code{gtTab = TRUE} and \code{writeTo} is specified.}
}
\value{
A \code{tibble::tibble()} if \code{gtTab = FALSE} (default), or \code{gt::gt()} object if \code{gtTab = TRUE}, with
rows of equality constraints (now with readable \code{param} labels) and test statistic, \emph{df}, and \emph{p} for whether constraint worsens model fit.
}
\description{
\code{outputConstraintTab()} is used to perform a score test for relaxing each
invariance equality constraint between partners in a given dyadic SEM model.
}
\details{
\itemize{
\item If \code{gtTab = TRUE} and \code{writeTo} is specified, then output will simultaneously be saved as a \code{.rtf} file to the user's specified directory.
\item If output file is successfully saved, a confirmation message will be printed to the console.
\item If a file with the same name already exists in the user's chosen directory, it will be overwritten.
}
}
\examples{
dvn <- scrapeVarCross(
  dat = commitmentM, x_order = "sip", x_stem = "sat.g",
  x_delim2 = "_", distinguish_1 = "f", distinguish_2 = "m"
)

sat.resids.script <- scriptCor(dvn,
  lvname = "Sat",
  constr_dy_meas = c("loadings", "intercepts", "residuals"),
  constr_dy_struct = "none"
)

sat.resids.mod <- lavaan::cfa(sat.resids.script,
  data = commitmentM, std.lv = FALSE,
  auto.fix.first = FALSE, meanstructure = TRUE
)

outputConstraintTab(sat.resids.mod,
  filterSig = FALSE,
  gtTab = TRUE, writeTo = tempdir(), fileName = "dCFA_Residual"
)

}
