% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddbs_extent_funs.R
\name{ddbs_bbox}
\alias{ddbs_bbox}
\title{Returns the minimal bounding box enclosing the input geometry}
\usage{
ddbs_bbox(
  x,
  by_feature = FALSE,
  conn = NULL,
  name = NULL,
  crs = NULL,
  crs_column = "crs_duckspatial",
  overwrite = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{x}{An \code{sf} spatial object. Alternatively, it can be a string with the
name of a table with geometry column within the DuckDB database \code{conn}.
Data is returned from this object.}

\item{by_feature}{Boolean. The function defaults to \code{FALSE}, and returns a
single bounding box for \code{x}. If \code{TRUE}, it return one bounding box for
each feature.}

\item{conn}{A connection object to a DuckDB database. If \code{NULL}, the function
runs on a temporary DuckDB database.}

\item{name}{A character string of length one specifying the name of the table,
or a character string of length two specifying the schema and table
names. If \code{NULL} (the default), the function returns the result as an
\code{sf} object}

\item{crs}{The coordinates reference system of the data. Specify if the data
doesn't have a \code{crs_column}, and you know the CRS.}

\item{crs_column}{a character string of length one specifying the column
storing the CRS (created automatically by \code{\link{ddbs_write_vector}}).
Set to \code{NULL} if absent.}

\item{overwrite}{Boolean. whether to overwrite the existing table if it exists. Defaults
to \code{FALSE}. This argument is ignored when \code{name} is \code{NULL}.}

\item{quiet}{A logical value. If \code{TRUE}, suppresses any informational messages.
Defaults to \code{FALSE}.}
}
\value{
an \code{sf} object or \code{TRUE} (invisibly) for table creation
}
\description{
Returns the minimal bounding box enclosing the input geometry from a \code{sf} object
or a DuckDB table. Returns the result as an \code{sf} object or creates a new
table in the database.
}
\examples{
\dontrun{
## load packages
library(duckspatial)
library(sf)

## read data
argentina_sf <- st_read(system.file("spatial/argentina.geojson", package = "duckspatial"))

# option 1: passing sf objects
ddbs_bbox(argentina_sf)


## option 2: passing the names of tables in a duckdb db

# creates a duckdb write sf to it
conn <- duckspatial::ddbs_create_conn()
ddbs_write_vector(conn, argentina_sf, "argentina_tbl", overwrite = TRUE)

output2 <- ddbs_bbox(
    conn = conn,
    x = "argentina_tbl",
    name = "argentina_bbox"
)

DBI::dbReadTable(conn, "argentina_bbox")
}
}
