% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds.ranksSecure.R
\name{ds.ranksSecure}
\alias{ds.ranksSecure}
\title{Secure ranking of a vector across all sources}
\usage{
ds.ranksSecure(
  input.var.name = NULL,
  quantiles.for.estimation = "0.05-0.95",
  generate.quantiles = TRUE,
  output.ranks.df = NULL,
  summary.output.ranks.df = NULL,
  ranks.sort.by = "ID.orig",
  shared.seed.value = 10,
  synth.real.ratio = 2,
  NA.manage = "NA.delete",
  rm.residual.objects = TRUE,
  monitor.progress = FALSE,
  datasources = NULL
)
}
\arguments{
\item{input.var.name}{a character string in a format that can pass through
the DataSHIELD R parser which specifies the name of the vector to be ranked.
Needs to have same name in each data source.}

\item{quantiles.for.estimation}{one of a restricted set of character strings.
To mitigate disclosure risk only the following set of quantiles can be
generated: c(0.025,0.05,0.10,0.20,0.25,0.30,0.3333,0.40,0.50,0.60,0.6667,
0.70,0.75,0.80,0.90,0.95,0.975). The allowable formats for the argument
are of the general form: "0.025-0.975" where the first number is the lowest
quantile to be estimated and the second number is the equivalent highest 
quantile to estimate. These two quantiles are then estimated along with
all allowable quantiles in between. The allowable argument values are then:
"0.025-0.975", "0.05-0.95", "0.10-0.90", "0.20-0.80". Two alternative values
are "quartiles" i.e. c(0.25,0.50,0.75), and "median" i.e. c(0.50). The
default value is "0.05-0.95". If the sample size is so small that an extreme
quartile could be disclosive the function will be terminated and an error 
message returned telling you that you might try using an argument with a
narrower set of quantiles. This disclosure trap will be triggered if the
total number of subjects across all studies divided by the total number
of quantile values being estimated is less than or equal to nfilter.tab
(the minimum cell size in a contingency table).}

\item{generate.quantiles}{a logical value indicating whether the
ds.ranksSecure function should carry on to estimate the key quantile
values specified by argument <quantiles.for.estimation> or should stop
once the global ranks have been created and written to the serverside.
Default is TRUE and as the key quantiles are generally non-disclosive this
is usually the setting to use. But, if there is some abnormal configuration
of the clusters of values that are being ranked such that some values are
treated as being missing and the processing stops, then setting
generate.quantiles to FALSE allows the generation of ranks to complete so
they can then be used for non-parametric analysis, even if the key values
cannot be estimated. A real example of an unusual configuration was in a
reasonably large dataset of survival times, where a substantial proportion
of survival profiles were censored at precisely 10 years. This meant that
the 97.5% percentile could not be separated from the 95% percentile and so
the former was allocated the value NA. This stopped processing of the ranks
which could then be enabled by setting generate.quantiles to FALSE. However,
if this problem is detected an error message is returned which indicates that
in some cases (as in this case in fact) the problem can be circumvented
by selecting a narrow range of key quantiles to estimate. In this case, in
fact, this simply required changing the <quantiles.for.estimation> argument
from "0.025-0.975" to "0.05-0.95".}

\item{output.ranks.df}{a character string in a format that can pass through
the DataSHIELD R parser which specifies an optional name for the
data.frame written to the serverside on each data source that contains
11 of the key output variables from the ranking procedure pertaining to that
particular data source. This includes the global ranks and quantiles of each
value of the V2BR (i.e. the values are ranked across all studies
simultaneously). If no name is specified, the default name
is allocated as "full.ranks.df". This data.frame contains disclosive
information and cannot therefore be passed to the clientside.}

\item{summary.output.ranks.df}{a character string in a format that can pass through
the DataSHIELD R parser which specifies an optional name for the summary
data.frame written to the serverside on each data source that contains
5 of the key output variables from the ranking procedure pertaining to that
particular data source. This again includes the global ranks and quantiles of each
value of the V2BR (i.e. the values are ranked across all studies
simultaneously). If no name is specified, the default name
is allocated as "summary.ranks.df" This data.frame contains disclosive
information and cannot therefore be passed to the clientside.}

\item{ranks.sort.by}{a character string taking two possible values. These
are "ID.orig" and "vals.orig". These define the order in which the
output.ranks.df and summary.output.ranks.df data frames are presented. If
the argument is set as "ID.orig" the order of rows in the output data frames
are precisely the same as the order of original input vector that is being
ranked (i.e. V2BR). This means the ranks can simply be cbinded to the
matrix, data frame or tibble that originally included V2BR so it also 
includes the corresponding ranks. If it is set as "vals.orig" the output
data frames are in order of increasing magnitude of the original values of
V2BR. Default value is "ID.orig".}

\item{shared.seed.value}{an integer value which is used to set the
random seed generator in each study. Initially, the seed is set to be the
same in all studies, so the order and parameters of the repeated
encryption procedures are precisely the same in each study. Then a 
study-specific modification of the seed in each study ensures that the
procedures initially generating the masking pseudodata (which are then
subject to the same encryption procedures as the real data) are different
in each study. For further information about the shared seed and how we
intend to transmit it in the future, please see the detailed associated
header document.}

\item{synth.real.ratio}{an integer value specifying the ratio between the
number of masking pseudodata values generated in each study compared to
the number of real data values in V2BR.}

\item{NA.manage}{character string taking three possible values: "NA.delete",
"NA.low","NA.hi". This argument determines how missing values are managed
before ranking. "NA.delete" results in all missing values being removed
prior to ranking. This means that the vector of ranks in each study is 
shorter than the original vector of V2BR values by an amount corresponding
to the number of missing values in V2BR in that study. Any rows containing
missing values in V2BR are simply removed before the ranking procedure is
initiated so the order of rows without missing data is unaltered. "NA.low"
indicates that all missing values should be converted to a new value that
has a meaningful magnitude that is lower (more negative or less positive)
than the lowest non-missing value of V2BR in any of the studies. This means,
for example, that if there are a total of M values of V2BR that are missing
across all studies, there will be a total of M observations that are ranked
lowest each with a rank of (M+1)/2. So if 7 are missing the lowest 7 ranks
will be 4,4,4,4,4,4,4 and if 4 are missing the first 4 ranks will be 
2.5,2.5,2.5,2.5. "NA.hi" indicates that all missing values should be
converted to a new value that has a meaningful magnitude that is higher(less
negative or more positive)than the highest non-missing value of V2BR in any
of the studies. This means, for example, that if there are a total of M
values of V2BR that are missing across all studies and N non-missing
values, there will be a total of M observations that are ranked
highest each with a rank of (2N-M+1)/2. So if there are a total of 1000
V2BR values and 9 are missing the highest 9 ranks will be 996, 996 ... 996.
If NA.manage is either "NA.low" or "NA.hi" the final rank vector in each
study  will have the same length as the V2BR vector in that same study.
2.5,2.5,2.5,2.5. The default value of the "NA.manage" argument is "NA.delete"}

\item{rm.residual.objects}{logical value. Default = TRUE: at the beginning
and end of each run of ds.ranksSecure delete all extraneous objects that are
otherwise left behind. These are not usually needed, but could be of value
if one were investigating a problem with the ranking. FALSE: do not delete
the residual objects}

\item{monitor.progress}{logical value. Default = FALSE. If TRUE, function
outputs information about its progress.}

\item{datasources}{specifies the particular opal object(s) to use. If the
<datasources> argument is not specified (NULL) the default set of opals
will be used. If <datasources> is specified, it should be set without
inverted commas: e.g. datasources=opals.em. If you wish to
apply the function solely to e.g. the second opal server in a set of three,
the argument can be specified as: e.g. datasources=opals.em[2].
If you wish to specify the first and third opal servers in a set you specify:
e.g. datasources=opals.em[c(1,3)].}
}
\value{
the data frame objects specified by the arguments output.ranks.df
and summary.output.ranks.df. These are written to the serverside in each
study. Provided the sort order is consistent these data frames can be cbinded
to any other data frame, matrix or tibble object containing V2BR or to the
V2BR vector itself, allowing the global ranks and quantiles to be
analysed rather than the actual values of V2BR. The last call within
the ds.ranksSecure function is to another clientside function
ds.extractQuantile (for further details see header for that function).
This returns an additional data frame "final.quantile.df" of which the first
column is the vector of key quantiles to be estimated as specified by the
argument <quantiles.for.estimation> and the second column is the list of
precise values of V2BR which correspond to these key quantiles. Because
the serverside functions associated with ds.ranksSecure and
ds.extractQuantile block potentially disclosive output (see information
for parameter quantiles.for.estimation) the "final.quantile.df" is returned
to the client allowing the direct reporting of V2BR values corresponding to
key quantiles such as the quartiles, the median and 95th percentile etc. In
addition a copy of the same data frame is also written to the serverside in
each study allowing the value of key quantiles such as the median to be
incorporated directly in calculations or transformations on the serverside
regardless in which study (or studies) those key quantile values have
occurred.
}
\description{
Securely generate the ranks of a numeric vector and estimate
true global quantiles across all data sources simultaneously
}
\details{
ds.ranksSecure is a clientside function which calls a series of
other clientside and serverside functions to securely generate the global
ranks of a numeric vector "V2BR" (vector to be ranked)
in order to set up analyses on V2BR based on
non-parametric methods, some types of survival analysis and to derive true
global quantiles (such as the median, lower (25%) and upper (75%) quartiles,
and the 95% and 97.5% quantiles) across all sources simultaneously. These
global quantiles are, in general, different to the mean or median of the
equivalent quantiles calculated independently in each data source separately.
For more details about the cluster of functions that collectively
enable secure global ranking and estimation of global quantiles see the 
associated document entitled "secure.global.ranking.docx".
}
\author{
Paul Burton 4th November, 2021
}
