% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2Dplots.R
\name{plot_gmm_2D_binned}
\alias{plot_gmm_2D_binned}
\title{Plot  of GMM decomposition for 2D binned data}
\usage{
plot_gmm_2D_binned(X, Y, gmm, opts)
}
\arguments{
\item{X}{Matrix of 2D data to decompose by GMM.}

\item{Y}{Vector of counts, with the same length as "X".
Applies only to binned data (Y = NULL, by default).}

\item{gmm}{Results of \code{\link{gaussian_mixture_2D}} decomposition}

\item{opts}{Parameters of run stored in \code{\link{GMM_2D_opts}} variable.}
}
\value{
A \code{ggplot} object showing the heatmap of binned two-dimensional
data with an overlay of the Gaussian mixture model decomposition. Mixture
component centers are indicated by points and covariance ellipses corresponding
to selected probability contours are drawn around each component.
}
\description{
Function plot the heatmap of binned data with marked GMM decomposition.
This plot is also return as regular output of \code{\link{runGMM2D}}.
}
\examples{
\donttest{
data(example2D)
custom.settings <- GMM_2D_opts
res <- runGMM2D(example2D[,1:2], example2D[,3], opts = custom.settings)

plot_gmm_2D_binned(example2D[,1:2], example2D[,3], res$model, custom.settings)
}

}
\seealso{
\code{\link{runGMM2D}}
}
