% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TimeTreesFunctions.R
\name{create_starting_tree}
\alias{create_starting_tree}
\title{Takes an airr clone object and tree and returns BEAST2 XML for setting the starting tree}
\usage{
create_starting_tree(
  clone,
  id,
  tree,
  include_germline_as_tip,
  tree_states,
  start_edge_length
)
}
\arguments{
\item{clone}{an \code{airrClone} object}

\item{id}{unique identifer for this analysis}

\item{tree}{starting tree, either a phylo object or a newick string}

\item{include_germline_as_tip}{include the germline as a tip}

\item{tree_states}{use states in the starting tree?}

\item{start_edge_length}{edge length to use for all branches in starting tree}
}
\value{
String of XML setting the starting tree
}
\description{
Takes an airr clone object and tree and returns BEAST2 XML for setting the starting tree
}
