% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cwrapper.R
\name{dgQ2DD_to_PROJTRI}
\alias{dgQ2DD_to_PROJTRI}
\title{Convert from Q2DD to PROJTRI}
\usage{
dgQ2DD_to_PROJTRI(dggs, in_quad, in_qx, in_qy)
}
\arguments{
\item{dggs}{A dggs object from dgconstruct()}

\item{in_quad}{Vector of quad numbers}

\item{in_qx}{Vector of quadrant x values}

\item{in_qy}{Vector of quadrant y values}
}
\value{
Returns a dggs object which can be passed to other dggridR
            functions
}
\description{
Uses a discrete global grid system to convert between Q2DD
            and PROJTRI (see vignette for details)
}
\examples{
\dontrun{
library(dggridR)
dggs <- dgconstruct(res=20)

dgQ2DD_to_PROJTRI(dggs, in_quad, in_qx, in_qy)
}

}
