% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tod.r
\name{mean.tod}
\alias{mean.tod}
\alias{sd}
\alias{sd.default}
\alias{sd.tod}
\alias{median.tod}
\alias{min.tod}
\alias{max.tod}
\alias{quantile.tod}
\title{Descriptive Statistics for time-of-day Vectors}
\usage{
\method{mean}{tod}(x, ...)

sd(x, ...)

\method{sd}{default}(x, na.rm = FALSE, ...)

\method{sd}{tod}(x, na.rm = FALSE, ...)

\method{median}{tod}(x, na.rm = FALSE, ...)

\method{min}{tod}(..., na.rm = FALSE)

\method{max}{tod}(..., na.rm = FALSE)

\method{quantile}{tod}(x, ...)
}
\arguments{
\item{x}{vector of class \code{tod}}

\item{...}{additional args passed on to base stats or circular
stats functions}

\item{na.rm}{often passed through to correponding functions in the circular packages.  Otherwise logitcal.  Defaults to \code{FALSE}.}
}
\value{
descriptive values as would be returned for non-circular numeric vectors
}
\description{
Functions to calculate descriptve values for timo-of-day vectors.
The heavy lifting is done by the \code{circular} package.
}
\details{
These functions are meant to provide the least surprising
descriptive values.
}
\examples{
times <- as.tod(c("21:53", NA, "22:30", "23:10", "23:58", "00:15", "01:01"))

mean(times)
mean(times, na.rm = TRUE)
}
\author{
Dr. Andreas Leha
}
