% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normality.R
\name{norm_sum}
\alias{norm_sum}
\title{Normality Test Summary Table for Numeric Variables}
\arguments{
\item{data}{A data frame containing numeric and non-numeric variables.
Only numeric variables are assessed for normality.}

\item{sample_size}{Integer. Maximum number of observations to use for the
Shapiro-Wilk test per variable (default = 5000).}
}
\value{
A \code{flextable} summarizing each numeric variable with Shapiro-Wilk
W statistic, formatted p-value, and distribution classification
("Normal" or "Skewed").
}
\description{
This function performs the Shapiro-Wilk normality test on all numeric variables
in a dataset and returns the results in a publication-ready \code{flextable}.
Extremely small p-values are displayed as "p < 0.001". The function
automatically detects numeric variables and ignores non-numeric columns.
}
\examples{
norm_sum(iris)
}
