% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_text_phylo.R
\encoding{UTF-8}
\name{geom_text_phylo}
\alias{geom_text_phylo}
\title{Label nodes on a phylogenetic tree plotted with ggtree}
\usage{
geom_text_phylo(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  parse = FALSE,
  nudge_x = 0,
  nudge_y = 0,
  node_type = "tip",
  auto_adjust = TRUE,
  check_overlap = FALSE,
  size.unit = "mm",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this layer.
When using a \verb{geom_*()} function to construct a layer, the \code{stat}
argument can be used the override the default coupling between geoms and
stats. The \code{stat} argument accepts the following:
\itemize{
\item A \code{Stat} ggproto subclass, for example \code{StatCount}.
\item A string naming the stat. To give the stat as a string, strip the
function name of the \code{stat_} prefix. For example, to use \code{stat_count()},
give the stat as \code{"count"}.
}}

\item{position}{A position adjustment to use on the data for this layer. This
can be used in various ways, including to prevent overplotting and
improving the display. The \code{position} argument accepts the following:
\itemize{
\item The result of calling a position function, such as \code{position_jitter()}.
This method allows for passing extra arguments to the position.
\item A string naming the position adjustment. To give the position as a
string, strip the function name of the \code{position_} prefix. For example,
to use \code{position_jitter()}, give the position as \code{"jitter"}.
}}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}'s \code{params} argument. These
arguments broadly fall into one of 4 categories below. Notably, further
arguments to the \code{position} argument, or aesthetics that are required
can \emph{not} be passed through \code{...}. Unknown arguments that are not part
of the 4 categories below are ignored.
\itemize{
\item Static aesthetics that are not mapped to a scale, but are at a fixed
value and apply to the layer as a whole. For example, \code{colour = "red"}
or \code{linewidth = 3}. The geom's documentation has an \strong{Aesthetics}
section that lists the available options. The 'required' aesthetics
cannot be passed on to the \code{params}. Please note that while passing
unmapped aesthetics as vectors is technically possible, the order and
required length is not guaranteed to be parallel to the input data.
\item When constructing a layer using
a \verb{stat_*()} function, the \code{...} argument can be used to pass on
parameters to the \code{geom} part of the layer. An example of this is
\code{stat_density(geom = "area", outline.type = "both")}. The geom's
documentation lists which parameters it can accept.
\item Inversely, when constructing a layer using a
\verb{geom_*()} function, the \code{...} argument can be used to pass on parameters
to the \code{stat} part of the layer. An example of this is
\code{geom_area(stat = "density", adjust = 0.5)}. The stat's documentation
lists which parameters it can accept.
\item The \code{key_glyph} argument of \code{\link[ggplot2:layer]{layer()}} may also be passed on through
\code{...}. This can be one of the functions described as
\link[ggplot2:draw_key]{key glyphs}, to change the display of the layer in the legend.
}}

\item{parse}{If \code{TRUE}, the labels will be parsed into expressions and
displayed as described in \code{?plotmath}.}

\item{nudge_x, nudge_y}{Horizontal and vertical adjustment to nudge labels by.
Useful for offsetting text from points, particularly on discrete scales.
Cannot be jointly specified with \code{position}.}

\item{node_type}{Determines the subset of nodes to label. Valid options are
"tip" for tip nodes, "internal" for non-tip nodes, and "all" for all nodes.}

\item{auto_adjust}{Should upside-down text labels automatically be rotated
180° to improve readability?}

\item{check_overlap}{If \code{TRUE}, text that overlaps previous text in the
same layer will not be plotted. \code{check_overlap} happens at draw time and in
the order of the data. Therefore data should be arranged by the label
column before calling \code{geom_text()}. Note that this argument is not
supported by \code{geom_label()}.}

\item{size.unit}{How the \code{size} aesthetic is interpreted: as millimetres
(\code{"mm"}, default), points (\code{"pt"}), centimetres (\code{"cm"}), inches (\code{"in"}),
or picas (\code{"pc"}).}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display. To include legend keys for all levels, even
when no data exists, use \code{TRUE}.  If \code{NA}, all levels are shown in legend,
but unobserved levels are omitted.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:annotation_borders]{annotation_borders()}}.}
}
\description{
This geom adds labels to all or a subset of the nodes of a phylogenetic tree
that has been plotted using \code{\link[ggtree:ggtree]{ggtree::ggtree()}}. It is therefore very similar
to \code{\link[ggtree:geom_tiplab]{ggtree::geom_tiplab()}}, \code{\link[ggtree:geom_tiplab2]{ggtree::geom_tiplab2()}},
\code{\link[ggtree:geom_nodelab]{ggtree::geom_nodelab()}}, and \code{\link[ggtree:geom_nodelab2]{ggtree::geom_nodelab2()}}. However, unlike
those geoms, this geom is intended to work with all coordinate systems,
including \code{\link[=coord_geo]{coord_geo()}} and \code{\link[=coord_geo_radial]{coord_geo_radial()}}.
}
\details{
Each label will be plotted with the same angle as the branch/edge leading to
its node by default. The \code{angle}, \code{hjust}, and \code{vjust} aesthetics can be used
to adjust this. If custom \code{angle} values are specified, these will be
\strong{added} to the default angle as calculated as described above.

As with \code{\link[ggplot2:geom_text]{ggplot2::geom_text()}}, the limits of axes will not be
expanded to accommodate the new labels, so you may need to extend them
manually using the \code{limits} or \code{expand} arguments within \code{scale_} or \code{coord_}
functions. Note that \code{\link[=coord_geo]{coord_geo()}} by default sets \code{expand = FALSE}.
}
\section{Aesthetics}{
 \code{geom_text_phylo()} understands the following
aesthetics (required aesthetics are in bold):
\itemize{
\item \strong{x} (pulled from the phylogeny by default)
\item \strong{y} (pulled from the phylogeny by default)
\item \strong{label} (pulled from the phylogeny by default)
\item alpha
\item angle
\item color/colour
\item family
\item fontface
\item group
\item hjust
\item lineheight
\item size
\item vjust
}
}

\section{Alignment}{


You can modify text alignment with the \code{vjust} and \code{hjust}
aesthetics. These can either be a number between 0 (left/bottom) and
1 (right/top) or a character (\code{"left"}, \code{"middle"}, \code{"right"}, \code{"bottom"},
\code{"center"}, \code{"top"}). There are two special alignments: \code{"inward"} and
\code{"outward"}. Inward always aligns text towards the center, and outward
aligns it away from the center.

}

\examples{
library(ggplot2)
\dontshow{if (require(ggtree)) withAutoprint(\{ # examplesIf}
library(ape)
library(ggtree)
tr <- rtree(10)
revts(ggtree(tr)) +
  geom_text_phylo() +
  coord_geo_radial("epochs")
\dontshow{\}) # examplesIf}
}
