% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pro_applicability_matrix.R
\name{pro_applicability_matrix}
\alias{pro_applicability_matrix}
\title{Check applicability of DQ functions on study data}
\usage{
pro_applicability_matrix(
  study_data,
  item_level = "item_level",
  split_segments = FALSE,
  label_col,
  max_vars_per_plot = 20,
  meta_data_segment,
  meta_data_dataframe,
  flip_mode = "noflip",
  meta_data_v2,
  meta_data = item_level,
  segment_level,
  dataframe_level
)
}
\arguments{
\item{study_data}{\link{data.frame} the data frame that contains the measurements}

\item{item_level}{\link{data.frame} the data frame that contains metadata
attributes of study data}

\item{split_segments}{\link{logical} return one matrix per study segment}

\item{label_col}{\link{variable attribute} the name of the column in the metadata
with labels of variables}

\item{max_vars_per_plot}{\link{integer} from=0. The maximum number of variables
per single plot.}

\item{meta_data_segment}{\link{data.frame} -- optional: Segment level metadata}

\item{meta_data_dataframe}{\link{data.frame} -- optional: Data frame level
metadata}

\item{flip_mode}{\link{enum} default | flip | noflip | auto. Should the plot be
in default orientation, flipped, not flipped or
auto-flipped. Not all options are always supported.
In general, this con be controlled by
setting the \code{roptions(dataquieR.flip_mode = ...)}. If
called from \code{dq_report}, you can also pass
\code{flip_mode} to all function calls or set them
specifically using \code{specific_args}.}

\item{meta_data_v2}{\link{character} path to workbook like metadata file, see
\code{\link{prep_load_workbook_like_file}} for details.
\strong{ALL LOADED DATAFRAMES WILL BE PURGED},
using \code{\link{prep_purge_data_frame_cache}},
if you specify \code{meta_data_v2}.}

\item{meta_data}{\link{data.frame} old name for \code{item_level}}

\item{segment_level}{\link{data.frame} alias for \code{meta_data_segment}}

\item{dataframe_level}{\link{data.frame} alias for \code{meta_data_dataframe}}
}
\value{
a list with:
\itemize{
\item \code{SummaryTable}: data frame about the applicability of each indicator
function (each function in a column).
its \link{integer} values can be one of the following four
categories:
0. Non-matching datatype + Incomplete metadata,
1. Non-matching datatype + complete metadata,
2. Matching datatype + Incomplete metadata,
3. Matching datatype + complete metadata,
4. Not applicable according to data type
\item \code{ApplicabilityPlot}: \link[ggplot2:ggplot2-package]{ggplot2::ggplot2} heatmap plot, graphical representation of
\code{SummaryTable}
\item \code{ApplicabilityPlotList}: \link{list} of plots per (maybe artificial) segment
\item \code{ReportSummaryTable}: data frame underlying \code{ApplicabilityPlot}
}
}
\description{
Checks applicability of DQ functions based on study data and metadata
characteristics
}
\details{
This is a preparatory support function that compares study data with
associated metadata. A prerequisite of this function is that the no. of
columns in the study data complies with the no. of rows in the metadata.

For each existing R-implementation, the function searches for necessary
static metadata and returns a heatmap like matrix indicating the
applicability of each data quality implementation.

In addition, the data type defined in the metadata is compared with the
observed data type in the study data.
}
