% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/D1Node.R
\docType{class}
\name{D1Node-class}
\alias{D1Node-class}
\title{A base class for CNode and MNode.}
\description{
D1Node is a base class for CNode and MNode classes and contains class slots and
methods that are common between these two child classes.
}
\section{Slots}{

\describe{
\item{\code{identifier}}{A character string containing a URN that uniquely identifiers the node}

\item{\code{name}}{A character string containing a plain text name for the node}

\item{\code{description}}{A character string describing the node}

\item{\code{baseURL}}{A character string of the registered baseURL for the node, which does not include the version string}

\item{\code{subject}}{A character string containing the Distinguished Name of this node, used for authentication}

\item{\code{contactSubject}}{The Distinguished Name of contact person for this node}

\item{\code{replicate}}{A logical flag indicating whether the node accepts replicas}

\item{\code{type}}{The node type, either 'mn' or 'cn'}

\item{\code{state}}{A character string that indicates whether or not the node is accessible, either 'up' or 'down'}

\item{\code{services}}{A data.frame containing the service tiers supported by this node.}

\item{\code{serviceUrls}}{A data.frame that contains DataONE service Urls}

\item{\code{APIversion}}{A character string indicating version of the DataONE API for this node, e.g. "v2"}

\item{\code{env}}{A character string, either 'prod' if this node is in the production environment, otherwise 'test'}
}}

\section{Methods}{

\itemize{
\item \link{D1Node-initialize}: Initialize a D1Node
\item \code{\link[=D1Node]{D1Node()}}: Create a MNode object representing a DataONE Member Node repository
\item \code{\link[=archive]{archive()}}: Change the state of an object so that it is hidden from searches
\item \code{\link[=describeObject]{describeObject()}}: Get header information for a given pid
\item \code{\link[=getChecksum]{getChecksum()}}: Get the checksum for the data object associated with the specified pid
\item \code{\link[=getObject]{getObject()}}: Get the bytes associated with an object on a node
\item \code{\link[=getQueryEngineDescription]{getQueryEngineDescription()}}: Query a node for the list of query engines available on the node
\item \code{\link[=getSystemMetadata]{getSystemMetadata()}}: Get the metadata describing system properties associated with an object on the Node
\item \code{\link[=listObjects]{listObjects()}}: Retrieve the list of objects that match the search parameters
\item \code{\link[=listQueryEngines]{listQueryEngines()}}: Query a node for the list of query engines available on the node
\item \code{\link[=ping]{ping()}}: Test if a node is online and accepting DataONE requests
\item \code{\link[=encodeSolr]{encodeSolr()}}: Encode the input for Solr Queries
\item \code{\link[=query]{query()}}: Search DataONE for data and metadata objects
\item \code{\link[=isAuthorized]{isAuthorized()}}: Check if an action is authorized for the specified identifier
}
}

