% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_sample.R
\name{data_sample}
\alias{data_sample}
\title{Data sampling abstractions}
\usage{
data_sample()
}
\value{
returns an object of class \code{data_sample}
}
\description{
Base class for sampling strategies that provide train/test splitting and k‑fold partitioning.
Two standard implementations are \code{sample_random()} and \code{sample_stratified()}.
}
\examples{
#using random sampling
sample <- sample_random()
tt <- train_test(sample, iris)

# distribution of train
table(tt$train$Species)

# preparing dataset into four folds
folds <- k_fold(sample, iris, 4)

# distribution of folds
tbl <- NULL
for (f in folds) {
 tbl <- rbind(tbl, table(f$Species))
}
head(tbl)
}
