% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_bayes_estimate.R
\name{migration_crossover}
\alias{migration_crossover}
\title{Perform a Migration Step Between Chains}
\usage{
migration_crossover(
  prms_across_chains,
  pis_across_chains,
  log_likes_across_chains,
  b = 0.001,
  ...
)
}
\arguments{
\item{prms_across_chains}{a numeric matrix of dimension \verb{p × n}, where \code{p}
is the number of parameters and \code{n} is the number of chains. Each column
contains the current parameter vector of a chain.}

\item{pis_across_chains}{a numeric vector of length \code{n}, containing the
current log-posterior values for each chain.}

\item{log_likes_across_chains}{a numeric vector of length \code{n}, containing the
current log-likelihood values for each chain.}

\item{b}{a small numeric value used to perturb the proposal parameters to
avoid degeneracy.}

\item{...}{additional arguments passed to \code{\link[=call_log_posterior_m]{call_log_posterior_m()}}.}
}
\value{
A list with the following components:
\itemize{
\item \code{new_prms_across_chains}: The updated parameter matrix of shape \verb{p × n}.
\item \code{new_pis_across_chains}: The updated vector of log-posterior values.
\item \code{new_log_likes_across_chains}: The updated vector of log-likelihood values.
}
}
\description{
In a migration step, a random subset of chains is selected. Each selected
chain \code{k} receives a proposal based on the next chain \code{(k + 1)} in the
sequence (cycling back to the first chain after the last). The proposed
parameters are slightly perturbed by uniform noise controlled by \code{b}.
All proposals are then evaluated simultaneously using Metropolis acceptance
probabilities via \code{\link[=call_log_posterior_m]{call_log_posterior_m()}}, and accepted proposals
replace the current values.
}
\seealso{
\link{full_crossover}, \code{\link[=call_log_posterior_m]{call_log_posterior_m()}}
}
\keyword{internal}
