with_mock_dir("chemical",{
# test_that("catch missing API", {
#   # Run register_ctxR(key = 'YOUR KEY', write = TRUE) prior to running tests
#
#   #store env variable so tests don't overwrite
#   # tmp <- Sys.getenv("CTX_API_KEY")
#   # on.exit(Sys.setenv("CTX_API_KEY" = tmp))
#   # if(Sys.getenv("CTX_API_KEY") == ""){
#   #   #set env variable temporarily for testing
#   #   Sys.setenv("CTX_API_KEY" = "stored_api_key")
#   # }
#
#   expect_message(get_chemical_details(DTXSID = 'DTXSID7020182', verbose = TRUE), 'Using stored API key!')
#   #expect_message(get_chemical_by_property_range(start = 1, end = 2, property = 'Density'), 'Using stored API key!')
#   expect_message(get_chem_info(DTXSID = 'DTXSID7020182', verbose = TRUE), 'Using stored API key!')
#   expect_message(get_fate_by_dtxsid(DTXSID = 'DTXSID7020182', verbose = TRUE), 'Using stored API key!')
#   expect_message(chemical_starts_with(word = 'DTXSID7020182', verbose = TRUE), 'Using stored API key!')
#   expect_message(chemical_equal(word = 'DTXSID7020182', verbose = TRUE), 'Using stored API key!')
#   expect_message(chemical_contains(word = 'DTXSID7020182', verbose = TRUE), 'Using stored API key!')
#   expect_message(get_msready_by_mass(start = 1, end = 2, verbose = TRUE), 'Using stored API key!')
#   expect_message(get_msready_by_formula(formula = 'C2H6', verbose = TRUE), 'Using stored API key!')
#   expect_message(get_msready_by_formula(formula = 'C2H6', verbose = TRUE), 'Using stored API key!')
#   expect_message(get_msready_by_dtxcid(DTXCID = 'DTXCID705545', verbose = TRUE), 'Using stored API key!')
#   expect_message(get_chemical_lists_by_type(type = 'other', verbose = TRUE), 'Using stored API key!')
#   expect_message(get_public_chemical_list_by_name(list_name = 'Biosolids2021', verbose = TRUE), 'Using stored API key!')
#   expect_message(get_lists_containing_chemical(DTXSID = 'DTXSID7020182', verbose = TRUE), 'Using stored API key!')
#   expect_message(get_chemicals_in_list(list_name = 'Biosolids2021', verbose = TRUE), 'Using stored API key!')
#   expect_message(get_all_public_chemical_lists(verbose = TRUE), 'Using stored API key!')
#   expect_message(get_chemical_mrv(DTXSID = 'DTXSID7020182', verbose = TRUE), 'Using stored API key!')
#   expect_message(get_chemical_mol(DTXSID = 'DTXSID7020182', verbose = TRUE), 'Using stored API key!')
#   expect_message(get_chemical_image(DTXSID = 'DTXSID7020182', verbose = TRUE), 'Using stored API key!')
#   expect_message(get_chemical_synonym(DTXSID = 'DTXSID7020182', verbose = TRUE), 'Using stored API key!')
# })

test_that("catch missing DTXSID/DTXCID", {
  expect_error(get_chemical_details(), 'Please input a DTXSID or DTXCID!')
  expect_error(check_existence_by_dtxsid(), 'Please input a DTXSID!')
  expect_error(get_chem_info(), 'Please input a DTXSID!')
  expect_error(get_fate_by_dtxsid(), 'Please input a DTXSID!')
  expect_error(get_msready_by_dtxcid(), 'Please input a non-null value for DTXCID!')
  expect_error(get_msready_by_dtxcid(DTXCID = 1), 'Please input a character string for the DTXCID parameter!')
  expect_error(get_lists_containing_chemical(), 'Please input a non-null value for DTXSID!')
  expect_error(get_chemical_mrv(), 'Please input a DTXSID or DTXCID!')
  expect_error(get_chemical_mol(), 'Please input a DTXSID or DTXCID!')
  expect_error(get_chemical_image(), 'Please input a DTXSID, DTXCID, gsid, or SMILES!')
  expect_error(get_chemical_synonym(), 'Please input a DTXSID!')
})

test_that('Catch both DTXSID and DTXCID', {
  expect_error(get_chemical_details(DTXSID = 'DTXSID7020182', DTXCID = 'DTXCID30182'), 'Please input either a DTXSID or DTXCID, but not both!')
  expect_error(get_chemical_mrv(DTXSID = 'DTXSID7020182', DTXCID = 'DTXCID30182'), 'Please input either a DTXSID or DTXCID, but not both!')
  expect_error(get_chemical_mol(DTXSID = 'DTXSID7020182', DTXCID = 'DTXCID30182'), 'Please input either a DTXSID or DTXCID, but not both!')
  expect_error(get_chemical_image(DTXSID = 'DTXSID7020182', DTXCID = 'DTXCID30182'), 'Please input only one DTXSID, DTXCID, or SMILES, and not multiple!')

})

test_that('Numeric range input errors and warnings', {
  expect_error(get_chemical_by_property_range(API_key = 'test_key'), 'Please input a numeric value for both start and end!')
  expect_error(get_chemical_by_property_range(start = 4, API_key = 'test_key'), 'Please input a numeric value for both start and end!')
  expect_error(get_chemical_by_property_range(end = 4, API_key = 'test_key'), 'Please input a numeric value for both start and end!')
  expect_error(get_chemical_by_property_range(start = 4, end = 'k', API_key = 'test_key'), 'Please input a numeric value for both start and end!')
  expect_error(get_chemical_by_property_range(start = TRUE, end = 4, API_key = 'test_key'), 'Please input a numeric value for both start and end!')
  expect_error(get_chemical_by_property_range(start = 3, end = 4, API_key = ctx_key()), 'Please input a value for property!')
  expect_error(get_msready_by_mass(API_key = 'test_key'), 'Please input a numeric value for both start and end!')
  expect_error(get_msready_by_mass(start = 4, API_key = 'test_key'), 'Please input a numeric value for both start and end!')
  expect_error(get_msready_by_mass(end = 4, API_key = 'test_key'), 'Please input a numeric value for both start and end!')
  expect_error(get_msready_by_mass(start = 4, end = 'k', API_key = 'test_key'), 'Please input a numeric value for both start and end!')
  expect_error(get_msready_by_mass(start = TRUE, end = 4, API_key = 'test_key'), 'Please input a numeric value for both start and end!')
  expect_error(get_msready_by_mass(start = -1, end = 4, API_key = 'test_key'), 'Both start and end must be non-negative!')
  expect_error(get_msready_by_mass(start = 4, end = -1, API_key = 'test_key'), 'Both start and end must be non-negative!')
  expect_warning(get_msready_by_mass(start = 4, end = 1, API_key = ctx_key()), 'Swapping values for start and end!')
  #expect_warning(get_chemical_by_property_range(start = 4, end = 3, property = 'density', API_key = ctx_key()), 'Swapping values for start and end!')

})

test_that('projection/type errors/warnings', {
  expect_error(get_chemical_details(DTXSID = 'DTXSID7020182', Projection = 't', API_key = 'test_key'), 'Please input a correct value for `Projection`!')
  expect_warning(get_chemical_details(DTXSID = 'DTXSID7020182', Projection =  2, API_key = ctx_key()), 'Setting `Projection` to `chemicaldetailstandard`')
  expect_warning(get_chemical_details(DTXSID = 'DTXSID7020182', Projection =  c('ntatoolkit', 'chemicaldetailstandard'), API_key = ctx_key()), 'Setting `Projection` to `chemicaldetailstandard`')
  expect_message(get_chemical_details(DTXSID = 'DTXSID7020182', Projection =  c('ntatoolkit', 'chemicaldetaitandard'), API_key = ctx_key()), 'Using `Projection` = ntatoolkit!')
  expect_warning(get_chem_info(DTXSID = 'DTXSID', type = c('', 'predicted'), API_key = ctx_key()), 'Setting type to ""!')
  expect_error(get_chem_info(DTXSID = 'DTXSID', type = 'l', API_key = ctx_key()), 'Please input a correct choice for type!')
  expect_error(get_chemical_lists_by_type(API_key = ctx_key()), 'Please input a value for parameter type')
  expect_error(get_chemical_lists_by_type(type = 1, API_key = ctx_key()), 'Please input a value for parameter type')
  expect_warning(get_chemical_lists_by_type(type = 'federal', Projection = 1, API_key = ctx_key()), 'Setting `Projection` to empty string!')
  expect_warning(get_chemical_lists_by_type(type = 'federal', Projection = '1', API_key = ctx_key()), 'Setting `Projection` to empty string!')
  expect_warning(get_chemical_lists_by_type(type = 'federal', Projection = c('', 'chemicallistall'), API_key = ctx_key()), 'Setting `Projection` to empty string!')
  expect_warning(get_public_chemical_list_by_name(list_name = 'federal', Projection = 1, API_key = ctx_key()), 'Setting `Projection` to empty string!')
  expect_warning(get_public_chemical_list_by_name(list_name = 'federal', Projection = '1', API_key = ctx_key()), 'Setting `Projection` to empty string!')
  expect_warning(get_public_chemical_list_by_name(list_name = 'federal', Projection = c('', 'chemicallistall'), API_key = ctx_key()), 'Setting `Projection` to empty string!')
  expect_warning(get_all_public_chemical_lists(Projection = 1, API_key = ctx_key()), 'Setting `Projection` to empty string!')
  expect_warning(get_all_public_chemical_lists(Projection = '1', API_key = ctx_key()), 'Setting `Projection` to empty string!')
  expect_warning(get_all_public_chemical_lists(Projection = c('', 'chemicallistall'), API_key = ctx_key()), 'Setting `Projection` to empty string!')
})

test_that('Word search errors', {
  expect_error(chemical_starts_with(), 'Please input a character value for word!')
  expect_error(chemical_starts_with(word = 1), 'Please input a character value for word!')
  expect_error(chemical_equal(), 'Please input a character value for word!')
  expect_error(chemical_equal(word = 1), 'Please input a character value for word!')
  expect_error(chemical_contains(), 'Please input a character value for word!')
  expect_error(chemical_contains(word = 1), 'Please input a character value for word!')
  expect_error(get_msready_by_formula(), 'Please input a non-null value for formula!')
  expect_error(get_msready_by_formula(formula = 1), 'Please input a character string for the formula parameter!')
  expect_error(get_public_chemical_list_by_name(), 'Please input list_name!')
  expect_error(get_lists_containing_chemical(), 'Please input a non-null value for DTXSID!')
  expect_error(get_chemicals_in_list(), 'Please input a character value for list_name!')
  expect_error(get_chemicals_in_list(list_name = 1), 'Please input a character value for list_name!')
  expect_error(get_chemicals_in_list_start(), 'Please input a character value for list_name!')
  expect_error(get_chemicals_in_list_start(list_name = 1), 'Please input a character value for list_name!')
  expect_error(get_chemicals_in_list_start(list_name = 'Biosolids2021'), 'Please input a character value for word!')
  expect_error(get_chemicals_in_list_start(list_name = 'Biosolids2021', word = 1), 'Please input a character value for word!')
  expect_error(get_chemicals_in_list_exact(), 'Please input a character value for list_name!')
  expect_error(get_chemicals_in_list_exact(list_name = 1), 'Please input a character value for list_name!')
  expect_error(get_chemicals_in_list_exact(list_name = 'Biosolids2021'), 'Please input a character value for word!')
  expect_error(get_chemicals_in_list_exact(list_name = 'Biosolids2021', word = 1), 'Please input a character value for word!')
  expect_error(get_chemicals_in_list_contain(), 'Please input a character value for list_name!')
  expect_error(get_chemicals_in_list_contain(list_name = 1), 'Please input a character value for list_name!')
  expect_error(get_chemicals_in_list_contain(list_name = 'Biosolids2021'), 'Please input a character value for word!')
  expect_error(get_chemicals_in_list_contain(list_name = 'Biosolids2021', word = 1), 'Please input a character value for word!')
})

test_that('Return data type', {
  expect_type(get_chemical_details(DTXSID = 'DTXSID7020182', API_key = ctx_key()), 'list')
  expect_type(get_chemical_details(DTXCID = 'DTXCID30182', API_key = ctx_key()), 'list')
  expect_type(get_chemical_details(DTXSID = '', API_key = ctx_key()), 'NULL')
  expect_type(check_existence_by_dtxsid(DTXSID = 'DTXSID7020182', API_key = ctx_key()), 'list')
  expect_type(check_existence_by_dtxsid(DTXSID = '', API_key = ctx_key()), 'NULL')
  #expect_type(get_chemical_details(DTXSID = 'DTXSID7020182', API_key = ''), 'NULL')
  #expect_type(get_chemical_by_property_range(start = 99.8, end = 100.2, property = 'boiling point', API_key = ctx_key()), 'list')
  #expect_type(get_chemical_by_property_range(start = 99.8, end = 100.2, property = 'nonsense', API_key = ctx_key()), 'NULL')
  expect_type(get_chem_info(DTXSID = 'DTXSID7020182', API_key = ctx_key()), 'list')
  expect_type(get_chem_info(DTXSID = 'DTXSID7020182', type = 'predicted', API_key = ctx_key()), 'list')
  expect_type(get_chem_info(DTXSID = '', API_key = ctx_key()), 'list')
  #expect_type(get_chem_info(DTXSID = 'DTXSID7020182', API_key = ''), 'NULL')
  expect_type(get_fate_by_dtxsid(DTXSID = 'DTXSID7020182', API_key = ctx_key()), 'list')
  expect_type(get_fate_by_dtxsid(DTXSID = '', API_key = ctx_key()), 'NULL')
  #expect_type(get_fate_by_dtxsid(DTXSID = 'DTXSID7020182', API_key = ''), 'NULL')
  expect_type(chemical_starts_with(word = 'DTXSID7020182', API_key = ctx_key()), 'list')
  expect_type(chemical_starts_with(word = '', API_key = ctx_key()), 'NULL')
  #expect_type(chemical_starts_with(word = 'DTXSID7020182', API_key = ''), 'NULL')
  expect_type(chemical_equal(word = 'Bisphenol A', API_key = ctx_key()), 'list')
  expect_type(chemical_equal(word = 'gvfds', API_key = ctx_key()), 'NULL')
  #expect_type(chemical_equal(word = 'Bisphenol A', API_key = ''), 'NULL')
  expect_type(chemical_contains(word = 'Bisphenol A', API_key = ctx_key()), 'list')
  expect_type(chemical_contains(word = 'gvfdsr7', API_key = ctx_key()), 'NULL')
  #expect_type(chemical_contains(word = 'Bisphenol A', API_key = ''), 'NULL')
  expect_type(get_msready_by_mass(start = 16.0313, end = 16.0314, API_key = ctx_key()), 'character')
  expect_type(get_msready_by_mass(start = 16.0314, end = 16.0314, API_key = ctx_key()), 'list')
  #expect_type(get_msready_by_mass(start = 16.0313, end = 16.0314, API_key =''), 'NULL')
  expect_type(get_msready_by_formula(formula = 'CH4', API_key = ctx_key()), 'character')
  expect_type(get_msready_by_formula(formula = '8x', API_key = ctx_key()), 'list')
  expect_type(get_msready_by_formula(formula = '', API_key = ctx_key()), 'NULL')
  #expect_type(get_msready_by_formula(formula = 'CH4', API_key = ''), 'NULL')
  expect_type(get_msready_by_dtxcid(DTXCID = 'DTXCID30182', API_key = ctx_key()), 'character')
  expect_type(get_msready_by_dtxcid(DTXCID = '', API_key = ctx_key()), 'NULL')
  #expect_type(get_msready_by_dtxcid(DTXCID = 'DTXCID30182', API_key = ''), 'NULL')
  expect_type(get_chemical_lists_by_type(type = 'federal', API_key = ctx_key()), 'list')
  expect_type(get_chemical_lists_by_type(type = '', API_key = ctx_key()), 'NULL')
  #expect_type(get_chemical_lists_by_type(type = 'federal', API_key = ''), 'NULL')
  expect_type(get_public_chemical_list_by_name(list_name = 'Biosolids2021', API_key = ctx_key()), 'list')
  expect_type(get_public_chemical_list_by_name(list_name = '', API_key = ctx_key()), 'NULL')
  #expect_type(get_public_chemical_list_by_name(list_name = 'BIOSOLIDS2021', API_key = ''), 'NULL')
  expect_type(get_lists_containing_chemical(DTXSID = 'DTXSID7020182', API_key = ctx_key()), 'character')
  expect_type(get_lists_containing_chemical(DTXSID = '', API_key = ctx_key()), 'NULL')
  #expect_type(get_lists_containing_chemical(DTXSID = 'DTXSID7020182', API_key = ''), 'NULL')
  expect_type(get_chemicals_in_list_start(list_name = 'CCL4', word = 'Bi', API_key = ctx_key()), 'character')
  expect_type(get_chemicals_in_list_start(list_name = 'CCL4', word = 'zy', API_key = ctx_key()), 'list')
  expect_type(get_chemicals_in_list_exact(list_name = 'Biosolids2021', word = 'Bisphenol A', API_key = ctx_key()), 'character')
  expect_type(get_chemicals_in_list_exact(list_name = 'Biosolids2021', word = 'zy', API_key = ctx_key()), 'list')
  expect_type(get_chemicals_in_list_start(list_name = 'CCL4', word = 'Bi', API_key = ctx_key()), 'character')
  expect_type(get_chemicals_in_list_start(list_name = 'CCL4', word = 'zy', API_key = ctx_key()), 'list')
  expect_type(get_chemicals_in_list(list_name = 'CCL4', API_key = ctx_key()), 'list')
  expect_type(get_chemicals_in_list(list_name = '', API_key = ctx_key()), 'NULL')
  #expect_type(get_chemicals_in_list(list_name = 'BIOSOLDIS2021', API_key = ''), 'NULL')
  expect_type(get_all_public_chemical_lists(API_key = ctx_key()), 'list')
  #expect_type(get_all_public_chemical_lists(API_key = ''), 'NULL')
  expect_type(get_chemical_mrv(DTXSID = 'DTXSID7020182', API_key = ctx_key()), 'NULL')
  expect_type(get_chemical_mrv(DTXCID = 'DTXCID30182'), 'NULL')
  expect_type(get_chemical_mrv(DTXSID = '', API_key = ctx_key()), 'NULL')
  #expect_type(get_chemical_mrv(DTXSID = 'DTXSID7020182', API_key = ''), 'NULL')
  #expect_type(get_chemical_mrv(DTXCID = 'DTXCID30182', API_key = ''), 'NULL')
  expect_type(get_chemical_mol(DTXSID = 'DTXSID7020182', API_key = ctx_key()), 'character')
  expect_type(get_chemical_mol(DTXCID = 'DTXCID30182'), 'character')
  expect_type(get_chemical_mol(DTXSID = '', API_key = ctx_key()), 'NULL')
  #expect_type(get_chemical_mol(DTXSID = 'DTXSID7020182', API_key = ''), 'NULL')
  #expect_type(get_chemical_mol(DTXCID = 'DTXCID30182', API_key = ''), 'NULL')
  expect_type(get_chemical_image(DTXSID = 'DTXSID7020182', API_key = ctx_key()), 'double')
  expect_type(get_chemical_image(DTXCID = 'DTXCID30182', format = 'png', API_key = ctx_key()), 'double')
  expect_type(get_chemical_image(DTXSID = '', format = 'svg', API_key = ctx_key()), 'NULL')
  #expect_type(get_chemical_image(DTXSID = 'DTXSID7020182', API_key = ''), 'NULL')
  #expect_type(get_chemical_image(DTXCID = 'DTXCID30182', format = 'png', API_key = ''), 'NULL')
  expect_type(get_chemical_synonym(DTXSID = 'DTXSID7020182', API_key = ctx_key()), 'list')
  expect_type(get_chemical_synonym(DTXSID = '', API_key = ctx_key()), 'NULL')
  #expect_type(get_chemical_synonym(DTXSID = 'DTXSID7020182', API_key = ''), 'NULL')
})

test_that('check helper functions', {
  expect_equal(prepare_word('test'), 'test')
  expect_equal(prepare_word('test?'), 'test')
  expect_equal(prepare_word('test?test'), 'test?test=')
  expect_equal(prepare_word('test?test?'), 'test?test%3f=')
  expect_type(create_data.table_chemical_details(), 'list')
  expect_type(create_data.table_chemical_details(index = 3), 'list')
  expect_type(create_data.table_chemical_details(index = 4), 'list')
  expect_type(create_data.table_chemical_details(index = 5), 'list')
  expect_type(create_data.table_chemical_details(index = 6), 'list')
  expect_type(create_data.table_chemical_details(index = 'f'), 'list')
})})

with_mock_dir('IUPAC', simplify = FALSE, {

test_that('IUPAC endpoint input errors', {
    expect_error(get_smiles(), 'Please input a character string for name!')
    expect_error(get_smiles(name = 3), 'Please input a character string for name!')
    expect_error(get_inchi(), 'Please input a character string for name!')
    expect_error(get_inchi(name = 3), 'Please input a character string for name!')
    expect_error(get_inchikey(), 'Please input a character string for name!')
    expect_error(get_inchikey(name = 3), 'Please input a character string for name!')
})


# test_that('Return data type', {
#   #expect_type(get_smiles(name = '', API_key = ctx_key()), 'NULL')
#   #expect_type(get_smiles(name = 'Acetamide', API_key = ctx_key()), 'character')
#   #expect_type(get_inchi(name = '', API_key = ctx_key()), 'NULL')
#   #expect_type(get_inchi(name = 'Acetamide', API_key = ctx_key()), 'character')
#   #expect_type(get_inchikey(name = '', API_key = ctx_key()), 'NULL')
#   #expect_type(get_inchikey(name = 'Acetamide', API_key = ctx_key()), 'character')
# })
})
