% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logger.R
\name{enable_logging}
\alias{enable_logging}
\alias{disable_logging}
\alias{is_logging_enabled}
\alias{log_trace}
\title{Verbose Logging}
\usage{
enable_logging()

disable_logging()

is_logging_enabled()

log_trace(msg, ..., capture = FALSE)
}
\arguments{
\item{msg}{The message to log}

\item{...}{Optional arguments to populate the format string}

\item{capture}{Capture print output of variables instead of interpolate}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

A family of wrappers of selected \code{\link[futile.logger:futile.logger-package]{futile.logger::futile.logger}} functions that control
the logging mechanism in \code{crmPack}. The \code{crmPack} uses \code{\link[futile.logger:futile.logger-package]{futile.logger::futile.logger}}
package for the logging purposes. All the messages logged in \code{crmPack} are
logged into \code{crmPack} logger at the \code{\link[futile.logger:logger.options]{futile.logger::TRACE}} level. Hence,
enabling verbose logging means that the logging threshold will be set to
\code{\link[futile.logger:logger.options]{futile.logger::TRACE}} for the \code{crmPack} logger, and disabling verbose
logging means that it will be set to \code{\link[futile.logger:logger.options]{futile.logger::FATAL}}.
}
\section{Functions}{
\itemize{
\item \code{enable_logging()}: A simple wrapper of
\code{\link[futile.logger:flog.threshold]{futile.logger::flog.threshold()}} that enables \code{crmPack} verbose logging by
setting logging threshold to \code{\link[futile.logger:logger.options]{futile.logger::TRACE}} for \code{crmPack} logger.

\item \code{disable_logging()}: A simple wrapper of
\code{\link[futile.logger:flog.threshold]{futile.logger::flog.threshold()}} that disables \code{crmPack} verbose logging
by setting logging threshold to \code{\link[futile.logger:logger.options]{futile.logger::FATAL}} for \code{crmPack}
logger.

\item \code{is_logging_enabled()}: A simple wrapper of
\code{\link[futile.logger:flog.logger]{futile.logger::flog.logger()}} that checks whether current threshold level
for \code{crmPack} logger is verbose, which is \code{\link[futile.logger:logger.options]{futile.logger::TRACE}}.
It returns \code{TRUE} if the current logging level is verbose, \code{FALSE}
otherwise.

\item \code{log_trace()}: A simple wrapper of
\code{\link[futile.logger:flog.logger]{futile.logger::flog.trace()}} that prints a log message in the \code{crmPack}
logger.

}}
