% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Data-class.R
\docType{class}
\name{DataDual-class}
\alias{DataDual-class}
\alias{.DataDual}
\alias{DataDual}
\alias{.DefaultDataDual}
\title{\code{DataDual}}
\usage{
DataDual(w = numeric(), ...)

.DefaultDataDual()
}
\arguments{
\item{w}{(\code{numeric})\cr the continuous vector of biomarker values.}

\item{...}{parameters passed to \code{\link[=Data]{Data()}}.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

\code{\link{DataDual}} is a class for the dual endpoint data.
It inherits from \code{\link{Data}} and it contains additional biomarker information.
}
\section{Slots}{

\describe{
\item{\code{w}}{(\code{numeric})\cr the continuous vector of biomarker values.}
}}

\note{
Typically, end users will not use the \code{.DefaultDataDual()} function.
}
\examples{
my_data <- DataDual(
  w = rnorm(8),
  x = c(0.1, 0.5, 1.5, 3, 6, 10, 10, 10),
  y = c(0, 0, 0, 0, 0, 0, 1, 0),
  doseGrid = c(
    0.1,
    0.5,
    1.5,
    3,
    6,
    seq(from = 10, to = 80, by = 2)
  )
)
my_data
}
