% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_blank_rows.R
\name{add_blank_rows}
\alias{add_blank_rows}
\title{Add Blank Row}
\usage{
add_blank_rows(x, variables = NULL, row_numbers = NULL, variable_level = NULL)
}
\arguments{
\item{x}{(\code{gtsummary})\cr
a 'gtsummary' table. The table must include a column named \code{'variable'}
in \code{x$table_body}.}

\item{variables, row_numbers, variable_level}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}} or \code{integer})\cr
\itemize{
\item \code{variables}: When a table contains variable summaries, use this argument
to add blank rows below the specified variable block.
\item \code{row_numbers}: Add blank rows after each row number specified.
\item \code{variable_level}: A single column name in \code{x$table_body} and blank rows
will be added after each unique level.
}}
}
\value{
updated 'gtsummary' table.
}
\description{
Add a blank row below each variable group defined by \code{variables} or below each
specified \code{row_numbers}. A blank row will not be added to the bottom of the table.

\emph{NOTE}: For HTML flextable output (which includes the RStudio IDE Viewer),
the blank rows do not render. But they will appear when the
table is rendered to Word.
}
\examples{
# Example 1 ----------------------------------
# Default to every variable used
trial |>
  tbl_roche_summary(
    by = trt,
    include = c(age, marker, grade),
    nonmissing = "always"
  ) |>
  add_blank_rows(variables = everything())

# Example 2 ----------------------------------
trial |>
  tbl_roche_summary(
    by = trt,
    include = c(age, marker, grade),
    nonmissing = "always"
  ) |>
  add_blank_rows(variables = age)
}
