% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny.R
\name{countdown_action}
\alias{countdown_action}
\title{Perform a Countdown Timer Action in a Shiny App}
\usage{
countdown_action(
  id,
  action = c("start", "stop", "reset", "bumpUp", "bumpDown"),
  session = NULL
)
}
\arguments{
\item{id}{A character vector with one or more \code{id} values for timers created
with \code{\link[=countdown]{countdown()}} or \code{\link[=countdown_fullscreen]{countdown_fullscreen()}}. Be sure to set the \code{id}
value when creating the timer.}

\item{action}{The action to perform, one of \code{"start"}, \code{"stop"}, \code{"reset"},
\code{"bumpUp"}, or \code{"bumpDown"}.}

\item{session}{The reactive \code{session} object for the current Shiny session.
In general, only required for expert or unusual use cases.}
}
\value{
Invisibly returns the \code{id} of the updated countdown timer(s).
}
\description{
Performs an action in a countdown timer dynamically in a Shiny app via server
logic. You can start, stop, reset, or bump time time (when the timer is
running) up or down. See \code{\link[=countdown_shiny_example]{countdown_shiny_example()}} for an example app
demonstrating the usage of \code{countdown_action()}.
}
\seealso{
Other Shiny functions: 
\code{\link{countdown_app}()},
\code{\link{countdown_shiny_example}()},
\code{\link{countdown_update}()}
}
\concept{Shiny functions}
