% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colocboost.R
\name{colocboost_validate_input_data}
\alias{colocboost_validate_input_data}
\title{Validate and Process All Input Data for ColocBoost}
\usage{
colocboost_validate_input_data(
  X = NULL,
  Y = NULL,
  sumstat = NULL,
  LD = NULL,
  dict_YX = NULL,
  dict_sumstatLD = NULL,
  effect_est = NULL,
  effect_se = NULL,
  effect_n = NULL,
  overlap_variables = FALSE,
  M = 500,
  min_abs_corr = 0.5
)
}
\arguments{
\item{X}{A list of genotype matrices for different outcomes, or a single matrix if all outcomes share the same genotypes.}

\item{Y}{A list of vectors of outcomes or an N by L matrix if it is considered for the same X and multiple outcomes.}

\item{sumstat}{A list of data.frames of summary statistics.}

\item{LD}{A list of correlation matrices indicating the LD matrix for each genotype.}

\item{dict_YX}{A L by 2 matrix of dictionary for X and Y if there exist subsets of outcomes corresponding to the same X matrix.}

\item{dict_sumstatLD}{A L by 2 matrix of dictionary for sumstat and LD if there exist subsets of outcomes corresponding to the same sumstat.}

\item{effect_est}{Matrix of variable regression coefficients (i.e. regression beta values) in the genomic region}

\item{effect_se}{Matrix of standard errors associated with the beta values}

\item{effect_n}{A scalar or a vector of sample sizes for estimating regression coefficients.}

\item{overlap_variables}{If overlap_variables = TRUE, only perform colocalization in the overlapped region.}

\item{M}{The maximum number of gradient boosting rounds for each outcome (default is 500).}

\item{min_abs_corr}{Minimum absolute correlation allowed in a confidence set.}
}
\value{
A list containing:
\item{X}{Processed list of genotype matrices}
\item{Y}{Processed list of phenotype vectors}
\item{yx_dict}{Dictionary mapping Y to X}
\item{keep_variable_individual}{List of variable names for each X matrix}
\item{sumstat}{Processed list of summary statistics data.frames}
\item{LD}{Processed list of LD matrices}
\item{sumstatLD_dict}{Dictionary mapping sumstat to LD}
\item{keep_variable_sumstat}{List of variant names for each sumstat}
\item{Z}{List of z-scores for each outcome}
\item{N_sumstat}{List of sample sizes for each outcome}
\item{Var_y}{List of phenotype variances for each outcome}
\item{SeBhat}{List of standard errors for each outcome}
\item{M_updated}{Updated M value (may be changed if LD not provided)}
\item{min_abs_corr_updated}{Updated min_abs_corr value (may be changed if LD not provided)}
\item{jk_equiv_corr_updated}{Updated jk_equiv_corr value}
\item{jk_equiv_loglik_updated}{Updated jk_equiv_loglik value}
\item{func_simplex_updated}{Updated func_simplex value}
}
\description{
Internal function to validate and process both individual-level and summary-level input data
}
\keyword{internal}
