% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{experiment_adaptive_thresholds}
\alias{experiment_adaptive_thresholds}
\title{Dataframe resulting from experiment to test the automatic selection of multicollinearity thresholds}
\format{
A dataframe with 10,000 rows and 9 variables:
\describe{
\item{input_rows}{Number of rows in the input data subset.}
\item{input_predictors}{Number of predictors in the input data subset.}
\item{output_predictors}{Number of predictors retained after filtering.}
\item{input_cor_q75}{75th percentile of pairwise correlations in the input data.}
\item{output_cor_q75}{75th percentile of pairwise correlations in the selected predictors.}
\item{input_cor_max}{Maximum pairwise correlation in the input data.}
\item{output_cor_max}{Maximum pairwise correlation in the selected predictors.}
\item{input_vif_max}{Maximum VIF in the input data.}
\item{output_vif_max}{Maximum VIF in the selected predictors.}
}
}
\usage{
data(experiment_adaptive_thresholds)
}
\description{
A dataframe summarizing 10,000 experiments validating the adaptive multicollinearity threshold system in \code{\link[=collinear]{collinear()}}. Each row records input data characteristics and the resulting multicollinearity metrics after filtering.
}
\details{
The source data is a synthetic dataframe with 500 columns and 10,000 rows generated using \code{distantia::zoo_simulate()} with correlated time series (\code{independent = FALSE}, \code{seasons = 0}).

Each iteration randomly subsets 10-100 predictors and 30-100 rows per predictor, then applies \code{\link[=collinear]{collinear()}} with automatic threshold configuration to assess:
\itemize{
\item Whether output VIF stays bounded between ~2.5 and ~7.5
\item How the system adapts to different correlation structures
\item How predictor retention scales with input size
}
}
\examples{
data(experiment_adaptive_thresholds)
str(experiment_adaptive_thresholds)
}
\seealso{
Other experiments: 
\code{\link{experiment_cor_vs_vif}},
\code{\link{gam_cor_to_vif}},
\code{\link{prediction_cor_to_vif}}
}
\concept{experiments}
\keyword{datasets}
