% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{generateMoboPlot2}
\alias{generateMoboPlot2}
\title{Generate a Multi-objective Optimization Plot}
\usage{
generateMoboPlot2(
  data,
  x = "Iteration",
  y,
  phaseCol = "Phase",
  fillColourGroup = "",
  ytext,
  legendPos = c(0.65, 0.85),
  labelPosFormulaY = "top",
  verticalLinePosY = 0.75
)
}
\arguments{
\item{data}{A data frame containing the data to be plotted.}

\item{x}{A string representing the column name in \code{data} to be used for the x-axis. Can be either numeric or factor. Default is \code{"Iteration"}.}

\item{y}{A string representing the column name in \code{data} to be used for the y-axis. This should be a numeric variable.}

\item{phaseCol}{the name of the column for the color of the phase (sampling or optimization)}

\item{fillColourGroup}{A string representing the column name in \code{data} that defines the fill color grouping for the plot. Default is \code{"ConditionID"}.}

\item{ytext}{A custom label for the y-axis. If not provided, the y-axis label will be the title-cased version of \code{y}.}

\item{legendPos}{A numeric vector of length 2 specifying the position of the legend inside the plot. Default is \code{c(0.65, 0.85)}.}

\item{labelPosFormulaY}{A string specifying the vertical position of the polynomial equation label in the plot. Acceptable values are \code{"top"}, \code{"center"}, or \code{"bottom"}. Default is \code{"top"}.}

\item{verticalLinePosY}{A numeric value of the y-coordinate where the "sampling" and "optimization" line should be drawn.}
}
\value{
A \code{ggplot} object representing the multi-objective optimization plot, ready to be rendered.
}
\description{
This function generates a multi-objective optimization plot using \code{ggplot2}. The plot visualizes the relationship between the \code{x} and \code{y} variables, grouping and coloring by a fill variable, with the option to customize legend position, labels, and annotation of sampling and optimization phases.
Appropriate if you use https://github.com/Pascal-Jansen/Bayesian-Optimization-for-Unity in version 1.1.0 or higher.
}
\examples{
library(ggplot2)
library(ggpmisc)

# Example with numeric x-axis
df <- data.frame(
  x = 1:20,
  y = rnorm(20),
  ConditionID = rep(c("A", "B"), 10),
  Phase = rep(c("Sampling", "Optimization"), 10)
)
generateMoboPlot2(data = df, x = "x", y = "y")
}
