% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/XStARS.R
\name{xestars}
\alias{xestars}
\title{Efficient stability selection of the best \code{coglasso} network}
\usage{
xestars(
  coglasso_obj,
  stars_thresh = 0.1,
  stars_subsample_ratio = NULL,
  rep_num = 20,
  max_iter = 10,
  old_sampling = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{coglasso_obj}{The object of \code{S3} class \code{coglasso} returned by \code{coglasso()}.}

\item{stars_thresh}{The threshold set for variability of the explored
networks at each iteration of the algorithm. The \eqn{\lambda_w} or the
\eqn{\lambda_b} associated to the most stable network before the threshold
is overcome is selected.}

\item{stars_subsample_ratio}{The proportion of samples in the multi-omics
data set to be randomly subsampled to estimate the variability of the
network under the given hyperparameters setting. Defaults to 80\% when the
number of samples is smaller than 144, otherwise it defaults to
\eqn{\frac{10}{n}\sqrt{n}}.}

\item{rep_num}{The amount of subsamples of the multi-omics data set used to
estimate the variability of the network under the given hyperparameters
setting. Defaults to 20.}

\item{max_iter}{The greatest number of times the algorithm is allowed to
choose a new best \eqn{\lambda_w}. Defaults to 10.}

\item{old_sampling}{Perform the same subsampling \code{xstars()} would if set to
TRUE. Makes a difference with bigger data sets, where computing
a correlation matrix could take significantly longer. Defaults to FALSE.}

\item{verbose}{Print information regarding the progress of the selection
procedure on the console.}
}
\value{
\code{xestars()} returns an object of \code{S3} class \code{select_coglasso}
containing the results of the selection
procedure, built upon the object of \code{S3} class \code{coglasso} returned by \code{coglasso()}.
\itemize{
\item ... are the same elements returned by \code{\link[=coglasso]{coglasso()}}.
\item \code{merge} is the "merged" adjacency matrix, the average of all the adjacency
matrices estimated across all the different subsamples for the selected
combination of \eqn{\lambda_w}, \eqn{\lambda_b}, and \eqn{c} values in the
last path explored before convergence. Each entry is a measure of how
recurrent the corresponding edge is across the subsamples.
\item \code{variability_lw}, \code{variability_lb} and \code{variability_c} are numeric vectors
of as many items as the number of \eqn{\lambda_w}, \eqn{\lambda_b}, and
\eqn{c} values explored. Each item is the variability of the network
estimated for the corresponding hyperparameter value, keeping the other two
hyperparameters fixed to their selected value.
\item \code{sel_index_c}, \code{sel_index_lw} and \code{sel_index_lb} are the indexes of the
final selected parameters \eqn{c}, \eqn{\lambda_w} and \eqn{\lambda_b}
leading to the most stable sparse network.
\item \code{sel_c}, \code{sel_lambda_w} and \code{sel_lambda_b} are the final selected
parameters \eqn{c}, \eqn{\lambda_w} and \eqn{\lambda_b} leading to the most
stable sparse network.
\item \code{sel_adj} is the adjacency matrix of the final selected network.
\item \code{sel_variability} is the variability of the final selected network.
\item \code{sel_density} is the density of the final selected network.
\item \code{sel_icov} is the inverse covariance matrix of the final selected network.
\item \code{sel_cov} optional, given only when \code{coglasso()} was called with
\code{cov_output = TRUE}. It is the covariance matrix associated with  the final
selected network.
\item \code{call} is the matched call.
\item \code{method} is the chosen model selection method. Here, it is "xestars".
}
}
\description{
\code{xestars()} provides a more efficient and lighter implementation
than \code{xstars()} to select the combination of hyperparameters given to
\code{coglasso()} yielding the most stable, yet sparse network. Stability is
computed upon network estimation from multiple subsamples of the multi-omics
data set, allowing repetition. Subsamples are collected for a fixed amount of
times (\code{rep_num}), and with a fixed proportion of the total number of samples
(\code{stars_subsample_ratio}).
}
\details{
\emph{eXtended Efficient StARS} (\emph{XEStARS}) is a more efficient and memory-light version of
\emph{XStARS}, the adaptation for \emph{collaborative graphical regression} of the method
published by Liu, H. \emph{et al.} (2010): Stability Approach to Regularization
Selection (StARS). \emph{StARS} was developed for network estimation regulated by
a single penalty parameter, while \emph{collaborative graphical lasso} needs to
explore three different hyperparameters. These all have, to different
degree, a direct influence on network sparsity, hence on
stability. For every
iteration, \code{xstars()} explores one of the three parameters (\eqn{\lambda_w},
\eqn{\lambda_b}, or \eqn{c}), keeping the other ones fixed at their previous
selected estimate, using the normal, one-dimentional \emph{StARS} approach, until
finding the best combination of the three. What makes it more efficient
than \code{xstars()} is the different way that the stability check is implemented
in the two algorithms. In \code{xstars()} (and even in the original \emph{StARS}), the
stability check is performed, for example, for every \eqn{\lambda_w} value
(or \eqn{\lambda_b}, or \eqn{c}), until all values are explored, and then it
when the algorithm selects the one yielding the most stable, yet sparse
network, and only then switching to the selection of the following
hyperparameter. In \code{xestars()}, the stability check becomes a \emph{stopping criterion}.
The moment that the stability threshold is passed, the value of the
hyperparameter currently being selected is fixed, and the switch to the next
one happens immediately, without exploring the whole landscape. This reduces
sensibly the number of iterations before convergence to a final network. \cr
The original \emph{XStARS} computes a new subsampling for every time the algorithm
switches from optimizing \eqn{\lambda_w}, \eqn{\lambda_b}, or \eqn{c}. This
does not allow to compare the hyperparameters on an equal ground, and can
slow the selection down with bigger data set or a larger hyperparameter
space. To allow a similar subsampling to \code{xstars()}, the \code{old_sampling}
parameter has been implemented. If set to TRUE, the subsampling is similar to
the one \code{xstars()} would perform. Otherwise, the subsampling is performed at
the beginning of the algorithm once and for all its iterations.
}
\examples{
cg <- coglasso(multi_omics_sd_micro, p = c(4, 2), nlambda_w = 3, 
               nlambda_b = 3, nc = 3, verbose = FALSE)
\donttest{
# Takes less than five seconds
sel_cg <- xestars(cg, verbose = FALSE)
}
}
