% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnd-cnd-conditions.R
\name{cnd-cnd-conditions}
\alias{cnd-cnd-conditions}
\alias{cnd:as_character_cnd_error}
\alias{cnd:cnd_document_conditions}
\alias{cnd:cnd_document_file}
\alias{cnd:cnd_document_pkg_reg}
\alias{cnd:cnd_generated_cleanup}
\alias{cnd:cnd_generated_write}
\alias{cnd:cond_cnd_class}
\alias{cnd:condition_message_generator}
\alias{cnd:condition_overwrite}
\alias{cnd:conditions_dots}
\alias{cnd:invalid_condition}
\alias{cnd:invalid_condition_message}
\alias{cnd:match_arg}
\alias{cnd:no_package_exports}
\alias{as_character_cnd_error}
\alias{cnd_document_conditions}
\alias{cnd_document_file}
\alias{cnd_document_pkg_reg}
\alias{cnd_generated_cleanup}
\alias{cnd_generated_write}
\alias{cond_cnd_class}
\alias{condition_message_generator}
\alias{condition_overwrite}
\alias{conditions_dots}
\alias{invalid_condition}
\alias{invalid_condition_message}
\alias{match_arg}
\alias{no_package_exports}
\alias{cnd:as_character_cnd_error/error}
\alias{cnd:cnd_document_conditions/warning}
\alias{cnd:cnd_document_file/error}
\alias{cnd:cnd_document_pkg_reg/error}
\alias{cnd:cnd_generated_cleanup/message}
\alias{cnd:cnd_generated_write/condition}
\alias{cnd:cond_cnd_class/error}
\alias{cnd:condition_message_generator/error}
\alias{cnd:condition_overwrite/warning}
\alias{cnd:conditions_dots/warning}
\alias{cnd:invalid_condition/error}
\alias{cnd:invalid_condition_message/error}
\alias{cnd:match_arg/error}
\alias{cnd:no_package_exports/warning}
\title{Conditions for \code{cnd}}
\description{
Conditions for \code{cnd}
}
\details{
The following conditions are defined in the \code{{cnd}} package.
}
\section{\code{\link[=cnd-package]{\{cnd\}}}}{

These conditions are made with the \code{{cnd}} package though the use of
\code{\link[=condition]{condition()}}.
}

\section{\code{{cnd}} conditions}{


\subsection{\code{cnd:as_character_cnd_error/error}}{
\describe{
\item{package}{\code{{cnd}}}
\item{class}{\code{cnd:as_character_cnd_error}}
\item{type}{\strong{error}}
}
You cannot coerce a \link{condition_generator} object to a character. This may have occurred when trying to put a condition function through \code{\link[=stop]{stop()}} or \link{warning}.  Instead, call the function first, then pass the result to \code{\link[=stop]{stop()}} or \code{\link[=warning]{warning()}}.

For example:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Instead of this
stop(my_condition)

# Do this
stop(my_condition())
}\if{html}{\out{</div>}}

}
\subsection{\code{cnd:cnd_document_conditions/warning}}{
\describe{
\item{package}{\code{{cnd}}}
\item{class}{\code{cnd:cnd_document_conditions}}
\item{type}{\strong{warning}}
}
Documentation will fail when no conditions are found.  You may be executing \code{\link[=cnd_document]{cnd_document()}} too early, before conditions have been registered.  You can try to find your conditions with \code{\link[=conditions]{conditions()}}.
}
\subsection{\code{cnd:cnd_document_file/error}}{
\describe{
\item{package}{\code{{cnd}}}
\item{class}{\code{cnd:cnd_document_file}}
\item{type}{\strong{error}}
}
The \code{file} argument to \code{\link[=cnd_document]{cnd_document()}} must be a file path, a connection object, or \code{NULL} to return the documentation as a character vector.  The default value should be suitable for standard use cases.
}
\subsection{\code{cnd:cnd_document_pkg_reg/error}}{
\describe{
\item{package}{\code{{cnd}}}
\item{class}{\code{cnd:cnd_document_pkg_reg}}
\item{type}{\strong{error}}
}
Both \code{package} and \code{registry} must be set to document conditions.You can set a registry by adding \code{\link[=cnd_create_registry]{cnd_create_registry()}} calls to your package code.
}
\subsection{\code{cnd:cnd_generated_cleanup/message}}{
\describe{
\item{package}{\code{{cnd}}}
\item{class}{\code{cnd:cnd_generated_cleanup}}
\item{type}{\strong{message}}
}
Some files created during the documentation process may become obsolete while updating your conditions.
}
\subsection{\code{cnd:cnd_generated_write/condition}}{
\describe{
\item{package}{\code{{cnd}}}
\item{class}{\code{cnd:cnd_generated_write}}
\item{type}{\strong{condition}}
}
This condition is signaled when \code{\link[=cnd_document]{cnd_document()}} needs to write new documentation files.
}
\subsection{\code{cnd:cond_cnd_class/error}}{
\describe{
\item{package}{\code{{cnd}}}
\item{class}{\code{cnd:cond_cnd_class}}
\item{type}{\strong{error}}
}
\code{\link[=cnd]{cnd()}} simple calls the appropriate function: \code{\link[=stop]{stop()}}, \code{\link[=warning]{warning()}}, or \code{\link[=message]{message()}} based on the \code{type} parameter from \code{\link[=condition]{condition()}}.
}
\subsection{\code{cnd:condition_message_generator/error}}{
\describe{
\item{package}{\code{{cnd}}}
\item{class}{\code{cnd:condition_message_generator}}
\item{type}{\strong{error}}
}
\link{condition_generator} objects are not conditions.   You may have made this mistake:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{x <- condition("my_condition")
conditionMessage(x)
}\if{html}{\out{</div>}}

Condition generators need to be called first before they can be used as conditions.  Try this instead:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{x <- condition("my_condition")
conditionMessage(x())
}\if{html}{\out{</div>}}

}
\subsection{\code{cnd:condition_overwrite/warning}}{
\describe{
\item{package}{\code{{cnd}}}
\item{class}{\code{cnd:condition_overwrite}}
\item{type}{\strong{warning}}
}
Defining a new condition with the same class and package as an existing condition will overwrite the previous definition.  It is recommended to either avoid this by fully defining your condition, or creating a new condition instead.
}
\subsection{\code{cnd:conditions_dots/warning}}{
\describe{
\item{package}{\code{{cnd}}}
\item{class}{\code{cnd:conditions_dots}}
\item{type}{\strong{warning}}
}
The \code{...} parameter in \code{\link[=conditions]{conditions()}} is meant for convenience.  Only a single argument is allowed.  Other parameters must be named  explicitly.

For example:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Instead of this
conditions("class", "package") # "package" is ignored with a warning

# Do this
conditions(class = "class", package = "package")
}\if{html}{\out{</div>}}

}
\subsection{\code{cnd:invalid_condition/error}}{
\describe{
\item{package}{\code{{cnd}}}
\item{class}{\code{cnd:invalid_condition}}
\item{type}{\strong{error}}
}
The \code{class}, \code{exports}, and \code{help} parameters must be a single character string.  If you are passing a function, it must be a valid function.
}
\subsection{\code{cnd:invalid_condition_message/error}}{
\describe{
\item{package}{\code{{cnd}}}
\item{class}{\code{cnd:invalid_condition_message}}
\item{type}{\strong{error}}
}
Conditions messages are displayed when invoked through \code{\link[=conditionMessage]{conditionMessage()}}.  You can set a static message by passing through a \code{character} vector, or a dynamic message by passing through a \code{function}.  The function should return a \code{character} vector.

When \code{message} is not set, a default "there was an error" message is used.
}
\subsection{\code{cnd:match_arg/error}}{
\describe{
\item{package}{\code{{cnd}}}
\item{class}{\code{cnd:match_arg}}
\item{type}{\strong{error}}
}
Mostly \code{\link[=match.arg]{match.arg()}} but with a custom condition
}
\subsection{\code{cnd:no_package_exports/warning}}{
\describe{
\item{package}{\code{{cnd}}}
\item{class}{\code{cnd:no_package_exports}}
\item{type}{\strong{warning}}
}
The \code{exports} parameter requires a \code{package}
}
}

\seealso{
\link{cnd-package} \link{condition}
}
\keyword{internal}
