\name{who_sm_criteria}
\alias{who_sm_criteria}
\title{
WHO Diagnostic Criteria for Systemic Mastocytosis (2016)
}
\description{
Evaluates the 2016 World Health Organization (WHO) diagnostic criteria for Systemic Mastocytosis (SM). Diagnosis requires either one major criterion and at least one minor criterion, OR at least three minor criteria.
}
\usage{
who_sm_criteria(bone_marrow_aggregates, aberrant_cd25_expression,
                kit_d816v_mutation, serum_tryptase_elevated,
                spindle_cells_abnormal)
}
\arguments{
  \item{bone_marrow_aggregates}{
Numeric (0 or 1). Major Criterion: Multifocal dense infiltrates of mast cells (>=15 mast cells in aggregates) detected in sections of bone marrow and/or other extracutaneous organs. (1 = Yes).
}
  \item{aberrant_cd25_expression}{
Numeric (0 or 1). Minor Criterion: Mast cells in bone marrow, blood, or other extracutaneous organs express CD25 (and/or CD2) in addition to normal mast cell markers. (1 = Yes).
}
  \item{kit_d816v_mutation}{
Numeric (0 or 1). Minor Criterion: Detection of KIT mutation at codon 816 in bone marrow, blood, or other extracutaneous organs. (1 = Yes).
}
  \item{serum_tryptase_elevated}{
Numeric (0 or 1). Minor Criterion: Serum total tryptase persistently exceeds 20 ng/mL (unless there is an associated clonal myeloid disorder). (1 = Yes).
}
  \item{spindle_cells_abnormal}{
Numeric (0 or 1). Minor Criterion: >25\% of mast cells in bone marrow or other extracutaneous organ sections are spindle-shaped or have atypical morphology, or >25\% of mast cells in bone marrow aspirate smears are immature or atypical. (1 = Yes).
}
}
\value{
A list containing:
\item{Diagnosis}{"Criteria Met for Systemic Mastocytosis" or "Criteria Not Met".}
\item{Criteria_Status}{A summary of the major criterion and the count of minor criteria met.}
}
\references{
Arber DA, Orazi A, Hasserjian R, et al. The 2016 revision to the World Health Organization classification of myeloid neoplasms and acute leukemia. Blood. 2016;127(20):2391-2405. doi:10.1182/blood-2016-03-643544
}
\examples{

# Example 1: Diagnosis Met (Major + 1 Minor)
# Aggregates present, KIT mutation present
who_sm_criteria(1, 0, 1, 0, 0)

# Example 2: Diagnosis Met (3 Minor)
# No aggregates, but CD25+, KIT+, Tryptase >20
who_sm_criteria(0, 1, 1, 1, 0)
}
