\name{webster_parkinsons_scale}
\alias{webster_parkinsons_scale}
\title{
Webster Rating Scale for Parkinson's Disease
}
\description{
Calculates the Webster Rating Scale score to assess the severity of Parkinson's disease symptoms and the degree of disability. The scale consists of 10 clinical items, each rated from 0 (Normal) to 3 (Severe impairment), yielding a total score from 0 to 30.
}
\usage{
webster_parkinsons_scale(bradykinesia, rigidity, posture, upper_extremity_swing,
                         gait, tremor, facies, seborrhea, speech, self_care)
}
\arguments{
  \item{bradykinesia}{
Numeric (0-3). Slowness of movement (hands, supination-pronation rate).
0: None.
1: Slowing of supination-pronation rate.
2: Moderate slowing, early fatigue.
3: Severe slowing.
}
  \item{rigidity}{
Numeric (0-3). Muscle stiffness.
0: None.
1: Slight rigidity in neck/shoulders.
2: Moderate rigidity in neck/shoulders/arms.
3: Severe rigidity.
}
  \item{posture}{
Numeric (0-3). Standing posture.
0: Normal.
1: Beginning forward flexion of head/neck.
2: Moderate flexion (Simian posture).
3: Severe flexion.
}
  \item{upper_extremity_swing}{
Numeric (0-3). Arm swing during walking.
0: Both arms swing well.
1: One arm definitely diminished.
2: One arm fails to swing.
3: Both arms fail to swing.
}
  \item{gait}{
Numeric (0-3). Walking ability.
0: Normal (stride 18-30 inches).
1: Shortened stride (12-18 inches), turning difficulty.
2: Stride 6-12 inches, shuffling, festination.
3: Onset of gait difficulty, freezing, propulsion.
}
  \item{tremor}{
Numeric (0-3). Involuntary shaking.
0: No tremor.
1: < 1 inch amplitude (hands).
2: Maximum amplitude 4 inches, severe excursion.
3: Continuous, > 4 inches, writing/feeding impossible.
}
  \item{facies}{
Numeric (0-3). Facial expression.
0: Normal.
1: Slight masking (poker face).
2: Moderate masking (lips parted).
3: Frozen face, mouth open 1/4 inch or more, drooling.
}
  \item{seborrhea}{
Numeric (0-3). Oiliness of skin.
0: None.
1: Increased oiliness.
2: Obvious oiliness.
3: Marked seborrhea.
}
  \item{speech}{
Numeric (0-3). Speech quality.
0: Clear.
1: Beginning montony/loss of volume.
2: Moderate hoarseness/monotony/dysarthria.
3: Marked hesitation/stuttering/incomprehensible.
}
  \item{self_care}{
Numeric (0-3). Independence in daily living.
0: No impairment.
1: Minor impairment (long time to dress).
2: Moderate impairment (requires help).
3: Severe impairment (cannot dress/feed self).
}
}
\value{
A list containing:
\item{Webster_Score}{The calculated total score (Range 0-30).}
\item{Severity_Classification}{Interpretation (Early Illness <= 10, Moderate Disability 11-20, Severe/Advanced > 20).}
}
\references{
Webster DD. Critical analysis of the disability in Parkinson's disease. Mod Treat. 1968;5(2):257-282.
}
\examples{

# Example 1: Moderate Disability
# Scores of 1 or 2 across domains
webster_parkinsons_scale(1, 2, 1, 2, 1, 2, 1, 0, 1, 1)

# Example 2: Severe Disease
# High scores in motor and self-care
webster_parkinsons_scale(3, 3, 3, 3, 3, 2, 3, 1, 2, 3)
}
