\name{simplified_pesi_score}
\alias{simplified_pesi_score}
\title{
Simplified Pulmonary Embolism Severity Index (sPESI)
}
\description{
Calculates the Simplified PESI score to predict 30-day mortality in patients with confirmed pulmonary embolism (PE). The score uses 6 variables to stratify patients into Low Risk (score of 0) or High Risk (score >= 1), aiding in the decision for outpatient versus inpatient management.
}
\usage{
simplified_pesi_score(age, cancer_history, chronic_cardiopulmonary_disease,
                      heart_rate, systolic_bp, oxygen_saturation)
}
\arguments{
  \item{age}{
Numeric. Patient age in years. (> 80 years adds 1 point).
}
  \item{cancer_history}{
Numeric (0 or 1). History of cancer. (1 = Yes, +1 point).
}
  \item{chronic_cardiopulmonary_disease}{
Numeric (0 or 1). History of chronic cardiopulmonary disease. (1 = Yes, +1 point).
}
  \item{heart_rate}{
Numeric. Heart rate in beats per minute. (>= 110 bpm adds 1 point).
}
  \item{systolic_bp}{
Numeric. Systolic blood pressure in mmHg. (< 100 mmHg adds 1 point).
}
  \item{oxygen_saturation}{
Numeric. Arterial oxyhemoglobin saturation (\%). (< 90\% adds 1 point).
}
}
\value{
A list containing:
\item{sPESI_Score}{The calculated total score (Range 0-6).}
\item{Risk_Category}{Classification (Low Risk = 0, High Risk >= 1).}
\item{Est_30_Day_Mortality}{Estimated 30-day mortality risk percentage.}
\item{Recommendation}{Suggested management strategy.}
}
\references{
Jiménez D, Aujesky D, Moores L, et al. Simplification of the pulmonary embolism severity index for prognostication in patients with acute symptomatic pulmonary embolism. Arch Intern Med. 2010;170(15):1383-1389. doi:10.1001/archinternmed.2010.199
}
\examples{

# Example 1: Low Risk
# 50yo, No Hx, HR 80, SBP 120, SpO2 98%
# Score = 0
simplified_pesi_score(50, 0, 0, 80, 120, 98)

# Example 2: High Risk
# 85yo (+1), HR 115 (+1), No other factors
# Score = 2
simplified_pesi_score(85, 0, 0, 115, 120, 95)
}
