\name{rome_iv_functional_biliary_sod}
\alias{rome_iv_functional_biliary_sod}
\title{
Rome IV Diagnostic Criteria for Functional Biliary Sphincter of Oddi Disorder (SOD)
}
\description{
Evaluates the Rome IV diagnostic criteria for Functional Biliary Sphincter of Oddi Disorder (SOD), which is characterized by recurrent episodes of biliary pain in the absence of structural or metabolic explanations. The diagnosis is based on a set of general criteria, with manometry used for subtype classification.
}
\usage{
rome_iv_functional_biliary_sod(episode_pain, other_pain_excluded,
                               normal_liver_enzymes, normal_pancreatic_enzymes,
                               normal_imaging, not_explained_by_other_condition,
                               manometry_normal_or_high)
}
\arguments{
  \item{episode_pain}{
Numeric (0 or 1). Presence of recurrent episodes of biliary pain (pain in the epigastrium and/or right upper quadrant, meeting specific characteristics). (1 = Yes).
}
  \item{other_pain_excluded}{
Numeric (0 or 1). Have other causes of abdominal pain been excluded? (1 = Yes).
}
  \item{normal_liver_enzymes}{
Numeric (0 or 1). Is there documentation of normal liver enzymes (ALT/AST, ALP) and bilirubin? (1 = Yes).
}
  \item{normal_pancreatic_enzymes}{
Numeric (0 or 1). Is there documentation of normal pancreatic enzymes (amylase/lipase)? (1 = Yes).
}
  \item{normal_imaging}{
Numeric (0 or 1). Is there documentation of normal transabdominal ultrasound or Endoscopic Ultrasound (EUS) with no structural abnormalities? (1 = Yes).
}
  \item{not_explained_by_other_condition}{
Numeric (0 or 1). Are symptoms NOT fully explained by another medical condition (e.g., celiac disease, peptic ulcer)? (1 = Yes).
}
  \item{manometry_normal_or_high}{
Numeric (0 or 1). Does Sphincter of Oddi manometry show elevated basal pressure or a normal pressure (used for subtyping)? (1 = Yes, pressure is high or normal).
}
}
\value{
A list containing:
\item{Diagnosis}{The diagnostic result, including subtype based on presumed manometry results (Type I/II if positive manometry, Type III if negative/manometry not done).}
}
\references{
Corazziari E, Shaffer EA, Hogan WJ, et al. Functional Disorders of the Gallbladder and Sphincter of Oddi. Gastroenterology. 2016;150:1443-1455. doi:10.1053/j.gastro.2016.02.044
}
\examples{

# Example 1: Type I/II SOD (General criteria met + positive manometry)
rome_iv_functional_biliary_sod(1, 1, 1, 1, 1, 1, 1)

# Example 2: Type III SOD (General criteria met + negative/unknown manometry)
rome_iv_functional_biliary_sod(1, 1, 1, 1, 1, 1, 0)
}
