\name{rome_iv_cnvs}
\alias{rome_iv_cnvs}
\title{
Rome IV Diagnostic Criteria for Chronic Nausea Vomiting Syndrome (CNVS)
}
\description{
Evaluates the Rome IV criteria for diagnosing Chronic Nausea Vomiting Syndrome (CNVS). Diagnosis requires bothersome nausea and/or vomiting at least 1 day per week, exclusion of self-induced vomiting, eating disorders, regurgitation, and rumination, absence of organic disease, and symptom duration of at least 3 months with onset at least 6 months prior.
}
\usage{
rome_iv_cnvs(nausea_at_least_1_day_per_week, vomiting_at_least_1_day_per_week,
             self_induced_vomiting_present, eating_disorder_present,
             regurgitation_present, rumination_present,
             organic_systemic_metabolic_disease_excluded,
             symptom_onset_ge_6_months_ago, symptoms_active_last_3_months)
}
\arguments{
  \item{nausea_at_least_1_day_per_week}{
Numeric (0 or 1). Is bothersome nausea present at least 1 day per week? (1 = Yes).
}
  \item{vomiting_at_least_1_day_per_week}{
Numeric (0 or 1). Is there one or more vomiting episodes per week? (1 = Yes).
}
  \item{self_induced_vomiting_present}{
Numeric (0 or 1). Is the vomiting self-induced? (1 = Yes). This excludes CNVS.
}
  \item{eating_disorder_present}{
Numeric (0 or 1). Is an eating disorder present? (1 = Yes). This excludes CNVS.
}
  \item{regurgitation_present}{
Numeric (0 or 1). Is regurgitation present? (1 = Yes). This excludes CNVS.
}
  \item{rumination_present}{
Numeric (0 or 1). Is rumination present? (1 = Yes). This excludes CNVS.
}
  \item{organic_systemic_metabolic_disease_excluded}{
Numeric (0 or 1). Have organic, systemic, or metabolic diseases been excluded (e.g., by upper endoscopy)? (1 = Yes).
}
  \item{symptom_onset_ge_6_months_ago}{
Numeric (0 or 1). Did symptoms start at least 6 months ago? (1 = Yes).
}
  \item{symptoms_active_last_3_months}{
Numeric (0 or 1). Have symptoms been active for the last 3 months? (1 = Yes).
}
}
\value{
A list containing:
\item{Diagnosis}{"Criteria Met for Chronic Nausea Vomiting Syndrome (CNVS)" or "Criteria Not Met".}
}
\references{
Stanghellini V, Chan FK, Hasler WL, et al. Gastroduodenal Disorders. Gastroenterology. 2016;150:1380-1392. doi:10.1053/j.gastro.2016.02.011
}
\examples{

# Example 1: Criteria Met
# Nausea 1/wk (1), No vomiting (0), Exclusions clear (0), Disease excluded (1), Duration met (1,1)
rome_iv_cnvs(1, 0, 0, 0, 0, 0, 1, 1, 1)

# Example 2: Criteria Not Met (Duration too short)
# Nausea 1/wk (1), No vomiting (0), Exclusions clear (0), Disease excluded (1), Onset <6mo (0)
rome_iv_cnvs(1, 0, 0, 0, 0, 0, 1, 0, 1)
}
