\name{rdos_score}
\alias{rdos_score}
\title{
Respiratory Distress Observation Scale (RDOS)
}
\description{
Calculates the RDOS score to assess respiratory distress in patients who are unable to self-report dyspnea (e.g., cognitive impairment, intubation, end-of-life). The score ranges from 0 to 16, with higher scores indicating greater distress.
}
\usage{
rdos_score(heart_rate, respiratory_rate, restlessness, paradoxical_breathing,
           accessory_muscle_use, grunting, nasal_flaring, look_of_fear)
}
\arguments{
  \item{heart_rate}{
Numeric. Heart rate in beats per minute.
<90: 0 pts.
90-109: 1 pt.
>=110: 2 pts.
}
  \item{respiratory_rate}{
Numeric. Respiratory rate in breaths per minute.
<=18: 0 pts.
19-30: 1 pt.
>30: 2 pts.
}
  \item{restlessness}{
String. "none" (0 pts), "occasional" (slight movements, 1 pt), "frequent" (movements, 2 pts).
}
  \item{paradoxical_breathing}{
Numeric (0 or 1). Abdomen moves in on inspiration. (1 = Yes, +2 pts).
}
  \item{accessory_muscle_use}{
String. Rise in clavicles during inspiration. "none" (0 pts), "slight" (1 pt), "pronounced" (2 pts).
}
  \item{grunting}{
Numeric (0 or 1). Guttural sound at end-expiration. (1 = Yes, +2 pts).
}
  \item{nasal_flaring}{
Numeric (0 or 1). Involuntary movement of nares. (1 = Yes, +2 pts).
}
  \item{look_of_fear}{
Numeric (0 or 1). Eyes wide open, facial muscles tense, brow furrowed, mouth open, teeth together. (1 = Yes, +2 pts).
}
}
\value{
A list containing:
\item{RDOS_Score}{The calculated total score (Range 0-16).}
\item{Interpretation}{Assessment of distress (e.g., <3: No distress, >=3: Distress requiring palliation).}
}
\references{
Campbell ML, Templin T, Walch J. A Respiratory Distress Observation Scale for patients unable to self-report dyspnea. J Palliat Med. 2010;13(3):285-290. doi:10.1089/jpm.2009.0229
}
\examples{

# Example 1: Severe Distress
# HR 120 (+2), RR 35 (+2), Frequent Restless (+2), Paradoxical (+2),
# Pronounced Accessory (+2), Grunting (+2), Flaring (+2), Fear (+2)
# Score = 16
rdos_score(120, 35, "frequent", 1, "pronounced", 1, 1, 1)

# Example 2: No Distress
# HR 70 (0), RR 16 (0), No signs
# Score = 0
rdos_score(70, 16, "none", 0, "none", 0, 0, 0)
}
