\name{rbc_compatibility_screen}
\alias{rbc_compatibility_screen}
\title{
RBC Units to Screen for Compatibility
}
\description{
Calculates the estimated number of red blood cell (RBC) units that need to be screened to find a specified number of antigen-negative units for a patient with red cell alloantibodies. The calculation uses standard antigen-negative prevalence rates (based on a predominantly Caucasian population data from the AABB).
}
\usage{
rbc_compatibility_screen(units_needed, antigens_selected)
}
\arguments{
  \item{units_needed}{
Numeric. The number of compatible units required for transfusion.
}
  \item{antigens_selected}{
Character vector. A list of antigens for which the donor units must be negative.
Supported codes:
"d" (RhD), "c_big" (C), "c_little" (c), "e_big" (E), "e_little" (e),
"k_big" (K/Kell), "k_little" (k/Cellano),
"fya" (Duffy a), "fyb" (Duffy b),
"jka" (Kidd a), "jkb" (Kidd b),
"lea" (Lewis a), "leb" (Lewis b),
"m", "n", "s_big" (S), "s_little" (s), "p1".
}
}
\details{
The formula is:
\deqn{Units\_to\_Screen = \frac{Units\_Needed}{P_1 \times P_2 \times ... \times P_n}}
Where \eqn{P} is the prevalence of antigen-negative donors in the population for each selected antibody.
}
\value{
A list containing:
\item{Units_to_Screen}{The estimated number of units to crossmatch (rounded up).}
\item{Combined_Antigen_Negative_Frequency}{The mathematical probability of finding a unit negative for all selected antigens.}
}
\references{
Fung MK, et al. AABB Technical Manual. 18th ed. Bethesda, MD: AABB; 2014.
}
\examples{

# Example 1: Anti-K and Anti-E
# K negative freq ~91%, E negative freq ~71%
# Need 2 units: 2 / (0.91 * 0.71) = 3.1 -> 4 units
rbc_compatibility_screen(2, c("k_big", "e_big"))

# Example 2: Multiple Antibodies (Anti-c, Anti-Fya)
# c negative ~20%, Fya negative ~34%
# Need 2 units: 2 / (0.20 * 0.34) = 29.4 -> 30 units
rbc_compatibility_screen(2, c("c_little", "fya"))
}
