\name{pucai_score}
\alias{pucai_score}
\title{
Pediatric Ulcerative Colitis Activity Index (PUCAI)
}
\description{
Calculates the PUCAI score to assess disease activity in pediatric patients with ulcerative colitis. The score is based on six clinical items: abdominal pain, rectal bleeding, stool consistency, number of stools per 24 hours, nocturnal stools, and activity level limitation.
}
\usage{
pucai_score(abdominal_pain, rectal_bleeding, stool_consistency, stools_per_24h,
            nocturnal_stools, activity_level)
}
\arguments{
  \item{abdominal_pain}{
Numeric. Score for abdominal pain: 0 (None), 5 (Ignoreable), 10 (Severe).
}
  \item{rectal_bleeding}{
Numeric. Score for rectal bleeding: 0 (None), 10 (Small amount/ <50\% of stools), 20 (Large amount/ >=50\% of stools), 30 (Daily). Note: Specific point assignments vary slightly by source definition (e.g., 0, 10, 20, 30 is common).
}
  \item{stool_consistency}{
Numeric. Score for stool consistency: 0 (Formed), 5 (Partially formed), 10 (Completely unformed).
}
  \item{stools_per_24h}{
Numeric. Score for number of stools per 24 hours: 0 (0-2), 5 (3-5), 10 (6-8), 15 (>8).
}
  \item{nocturnal_stools}{
Numeric. Score for nocturnal stools: 0 (No), 10 (Yes).
}
  \item{activity_level}{
Numeric. Score for activity level: 0 (No limitation), 5 (Occasional limitation), 10 (Severe limitation).
}
}
\value{
A list containing:
\item{PUCAI_Score}{The calculated total score (Range 0-85).}
\item{Disease_Activity}{Classification of disease severity (Remission <10, Mild 10-34, Moderate 35-64, Severe >=65).}
}
\references{
Turner D, Otley AR, Mack D, et al. Development, validation, and evaluation of a pediatric ulcerative colitis activity index: a prospective multicenter study. Gastroenterology. 2007;133(2):423-432. doi:10.1053/j.gastro.2007.05.012
}
\examples{

# Example 1: Mild Disease
# Pain(5), Bleeding(10), Consistency(5), Freq(0), Nocturnal(0), Activity(0)
# Score = 20
pucai_score(5, 10, 5, 0, 0, 0)

# Example 2: Severe Disease
# Pain(10), Bleeding(30), Consistency(10), Freq(15), Nocturnal(10), Activity(10)
# Score = 85
pucai_score(10, 30, 10, 15, 10, 10)
}
