\name{pediatric_ins_outs}
\alias{pediatric_ins_outs}
\title{
Pediatric Ins and Outs (Maintenance Fluids and Urine Output)
}
\description{
Calculates the maintenance fluid requirements using the Holliday-Segar (4-2-1) Rule and estimates the target urine output based on the child's weight. This provides a guideline for fluid management and monitoring renal function in pediatric patients.
}
\usage{
pediatric_ins_outs(weight_kg)
}
\arguments{
  \item{weight_kg}{
Numeric. The patient's weight in kilograms.
}
}
\details{
\strong{Maintenance Fluids (4-2-1 Rule):}
\itemize{
  \item 0-10 kg: 4 mL/kg/hr
  \item 10-20 kg: 40 mL/hr + 2 mL/kg/hr for every kg above 10
  \item >20 kg: 60 mL/hr + 1 mL/kg/hr for every kg above 20
}

\strong{Target Urine Output (Estimates):}
\itemize{
  \item Infants/Young Children: ~1-2 mL/kg/hr
  \item Children: ~1 mL/kg/hr
  \item Adolescents: ~0.5-1 mL/kg/hr
}
}
\value{
A list containing:
\item{Maintenance_Rate_mL_hr}{The calculated hourly maintenance fluid rate.}
\item{Maintenance_Volume_24h_mL}{The total daily maintenance fluid volume.}
\item{Target_Urine_Output_mL_hr}{The estimated range for adequate urine output in mL/hr.}
\item{Target_Description}{The specific rate standard used based on weight.}
}
\references{
Holliday MA, Segar WE. The maintenance need for water in parenteral fluid therapy. Pediatrics. 1957;19(5):823-832.
}
\examples{

# Example 1: 8 kg Infant
# Maint = 32 mL/hr, UO Target 8-16 mL/hr
pediatric_ins_outs(8)

# Example 2: 15 kg Child
# Maint = 40 + (5*2) = 50 mL/hr, UO Target 15-22.5 mL/hr
pediatric_ins_outs(15)

# Example 3: 50 kg Adolescent
# Maint = 60 + (30*1) = 90 mL/hr, UO Target 25-50 mL/hr
pediatric_ins_outs(50)
}
