\name{oxygenation_index}
\alias{oxygenation_index}
\title{
Oxygenation Index (OI)
}
\description{
Calculates the Oxygenation Index (OI), a dimensionless number used primarily in neonatal and pediatric intensive care to assess the severity of hypoxic respiratory failure. It integrates Mean Airway Pressure (MAP) to quantify the intensity of ventilatory support required to maintain oxygenation. High values correlate with increased mortality and are used as criteria for advanced interventions like HFOV or ECMO.
}
\usage{
oxygenation_index(mean_airway_pressure, fio2_percent, pao2)
}
\arguments{
  \item{mean_airway_pressure}{
Numeric. Mean Airway Pressure (MAP) in cm H2O.
}
  \item{fio2_percent}{
Numeric. Fraction of Inspired Oxygen as a percentage (e.g., 100 for 100\% oxygen).
}
  \item{pao2}{
Numeric. Partial pressure of arterial oxygen in mmHg.
}
}
\details{
The formula is:
\deqn{OI = \frac{FiO_2 (\%) \times MAP}{PaO_2}}
Common clinical thresholds:
\itemize{
  \item OI > 25: High risk, consider HFOV/iNO.
  \item OI > 40: Very high risk, consider ECMO.
}
}
\value{
A list containing:
\item{Oxygenation_Index}{The calculated OI value.}
\item{Interpretation}{Clinical guidance based on standard severity thresholds.}
}
\references{
Ortiz RM, Cilley RE, Bartlett RH. Extracorporeal membrane oxygenation in pediatric respiratory failure. Pediatr Clin North Am. 1987;34(1):39-46.
Trachsel D, McCrindle BW, Nakagawa S, Bohn D. Oxygenation index predicts mortality in children with acute hypoxemic respiratory failure. Am J Respir Crit Care Med. 2005;172(2):206-211. doi:10.1164/rccm.200405-625OC
}
\examples{

# Example 1: Severe Failure (ECMO candidate)
# MAP 30, FiO2 100%, PaO2 60
# OI = (100 * 30) / 60 = 50
oxygenation_index(30, 100, 60)

# Example 2: Mild/Moderate
# MAP 15, FiO2 50%, PaO2 80
# OI = (50 * 15) / 80 = 9.38
oxygenation_index(15, 50, 80)
}
