\name{ohts_risk_score}
\alias{ohts_risk_score}
\title{
Ocular Hypertension Treatment Study (OHTS) Calculator
}
\description{
Calculates the 5-year risk of developing Primary Open-Angle Glaucoma (POAG) in patients with Ocular Hypertension. This function utilizes the point-based scoring system derived from the OHTS and European Glaucoma Prevention Study (EGPS) pooled data. It considers Age, Intraocular Pressure (IOP), Central Corneal Thickness (CCT), Vertical Cup-Disc Ratio (VCDR), and Pattern Standard Deviation (PSD).
}
\usage{
ohts_risk_score(age, iop, cct, vcdr, psd)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
}
  \item{iop}{
Numeric. Intraocular Pressure in mm Hg (mean of measurements).
}
  \item{cct}{
Numeric. Central Corneal Thickness in micrometers.
}
  \item{vcdr}{
Numeric. Vertical Cup-to-Disc Ratio (0.0 to 1.0).
}
  \item{psd}{
Numeric. Pattern Standard Deviation (dB) from visual field testing (Humphrey 24-2 or 30-2).
}
}
\value{
A list containing:
\item{OHTS_Points}{The calculated total risk points (Range 0-13+).}
\item{Five_Year_POAG_Risk}{The estimated percentage risk of developing POAG within 5 years.}
\item{Risk_Category}{Classification of risk (Low, Intermediate, High).}
}
\references{
Gordon MO, Beiser JA, Brandt JD, et al. The Ocular Hypertension Treatment Study: baseline factors that predict the onset of primary open-angle glaucoma. Arch Ophthalmol. 2002;120(6):714-720. doi:10.1001/archopht.120.6.714
OHTS/EGPS Investigators. A Validated Prediction Model for the Development of Primary Open-Angle Glaucoma in Individuals with Ocular Hypertension. Ophthalmology. 2007;114(1):10-19.
}
\examples{

# Example 1: Low Risk
# Age 45, IOP 21, CCT 600, VCDR 0.3, PSD 1.5
# Points: 0+0+0+0+0 = 0
ohts_risk_score(45, 21, 600, 0.3, 1.5)

# Example 2: High Risk
# Age 72, IOP 28, CCT 540, VCDR 0.7, PSD 2.8
# Points: 3+3+2+2+2 = 12
ohts_risk_score(72, 28, 540, 0.7, 2.8)
}
